/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BalloonOrder;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.common.items.BolloomBalloonItem;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import com.minecraftabnormals.endergetic.core.interfaces.CustomBalloonPositioner;
import com.minecraftabnormals.endergetic.core.registry.other.EEDataProcessors;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoatEntity.class})
public abstract class BoatEntityMixin
extends Entity
implements CustomBalloonPositioner {
    private static final ResourceLocation LARGE_BOAT_NAME = new ResourceLocation("extraboats", "large_boat");

    private BoatEntityMixin(EntityType<?> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void onBalloonAttached(BolloomBalloonEntity balloon) {
        if (!balloon.field_70170_p.field_72995_K && !balloon.hasModifiedBoatOrder) {
            HashMap orderMap = Maps.newHashMap((Map)((Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA)));
            orderMap.put(balloon.func_110124_au(), BoatEntityMixin.getClosestOpenOrder(orderMap));
            ((IDataManager)this).setValue(EEDataProcessors.ORDER_DATA, (Object)orderMap);
            balloon.hasModifiedBoatOrder = true;
        }
    }

    @Override
    public void onBalloonDetached(BolloomBalloonEntity balloon) {
        if (!balloon.field_70170_p.field_72995_K) {
            HashMap orderMap = Maps.newHashMap((Map)((Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA)));
            orderMap.remove(balloon.func_110124_au());
            ((IDataManager)this).setValue(EEDataProcessors.ORDER_DATA, (Object)orderMap);
        }
    }

    @Override
    public void updateAttachedPosition(BolloomBalloonEntity balloon) {
        Map orderMap = (Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA);
        if (!orderMap.containsKey(balloon.func_110124_au())) {
            return;
        }
        BalloonOrder balloonOrder = (BalloonOrder)((Object)orderMap.get(balloon.func_110124_au()));
        Vector3d attachedOffset = new Vector3d(this.func_200600_R() == ForgeRegistries.ENTITIES.getValue(LARGE_BOAT_NAME) ? (double)balloonOrder.largeX : (double)balloonOrder.normalX, 0.0, (double)balloonOrder.normalZ).func_178785_b((float)((double)(-this.field_70177_z) * (Math.PI / 180) - 1.5707963267948966));
        balloon.func_70107_b(this.func_226277_ct_() + attachedOffset.func_82615_a() + (double)balloon.getSway() * Math.sin(-balloon.getAngle()), this.func_226278_cu_() + balloon.func_70042_X() + (double)balloon.func_70047_e(), this.func_226281_cx_() + attachedOffset.func_82616_c() + (double)balloon.getSway() * Math.cos(-balloon.getAngle()));
    }

    private static BalloonOrder getClosestOpenOrder(Map<UUID, BalloonOrder> orderMap) {
        HashSet missingNumbers = Sets.newHashSet();
        Set<Integer> orders = BalloonOrder.toOrdinalSet(Sets.newHashSet(orderMap.values()));
        for (int i = 0; i < 4; ++i) {
            if (orders.contains(i)) continue;
            missingNumbers.add(i);
        }
        return BalloonOrder.byOrdinal(missingNumbers.isEmpty() ? orders.size() : ((Integer)missingNumbers.stream().sorted(Comparator.comparingInt(Math::abs)).collect(Collectors.toList()).get(0)).intValue());
    }

    @Inject(at={@At(value="TAIL")}, method={"floatBoat"})
    private void handleBalloonMotion(CallbackInfo info) {
        int balloons = ((BalloonHolder)((Object)this)).getBalloons().size();
        if (balloons > 0) {
            Vector3d motion = this.func_213322_ci();
            if (motion.func_82617_b() <= 0.0 && balloons <= 2) {
                this.func_213317_d(motion.func_216372_d(1.0, (double)(0.85f / (float)balloons), 1.0));
            } else if (balloons > 2) {
                float boost = (float)balloons / 2.0f * 0.045f;
                this.func_213317_d(new Vector3d(motion.func_82615_a(), MathHelper.func_151237_a((double)(motion.func_82617_b() + (double)boost), (double)-1.0, (double)boost), motion.func_82616_c()));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"interact"}, cancellable=true)
    private void addBalloonAttachingInteraction(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
        ItemStack stack = player.func_184586_b(hand);
        Entity boat = this.getEntity();
        Item item = stack.func_77973_b();
        if (item instanceof BolloomBalloonItem && BolloomBalloonItem.canAttachBalloonToTarget(boat)) {
            player.func_226292_a_(hand, true);
            if (!boat.field_70170_p.field_72995_K) {
                BolloomBalloonItem.attachToEntity(((BolloomBalloonItem)item).getBalloonColor(), boat);
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            info.setReturnValue((Object)ActionResultType.CONSUME);
        }
    }
}

