/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.registry.other;

import com.google.common.collect.Maps;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataProcessor;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedData;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BalloonOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public final class EEDataProcessors {
    private static final IDataProcessor<Map<UUID, BalloonOrder>> ORDER_PROCESSOR = new IDataProcessor<Map<UUID, BalloonOrder>>(){

        public CompoundNBT write(Map<UUID, BalloonOrder> map) {
            ListNBT entries = new ListNBT();
            map.forEach((uuid, balloonOrder) -> {
                CompoundNBT entry = new CompoundNBT();
                entry.func_186854_a("UUID", uuid);
                entry.func_74768_a("Order", balloonOrder.ordinal());
                entries.add((Object)entry);
            });
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("Entries", (INBT)entries);
            return compound;
        }

        public Map<UUID, BalloonOrder> read(CompoundNBT compound) {
            HashMap map = Maps.newHashMap();
            compound.func_150295_c("Entries", 10).forEach(nbt -> {
                CompoundNBT entry = (CompoundNBT)nbt;
                if (entry.func_150297_b("UUID", 11) && entry.func_150297_b("Order", 3)) {
                    map.put(entry.func_186857_a("UUID"), BalloonOrder.byOrdinal(entry.func_74762_e("Order")));
                }
            });
            return map;
        }
    };
    public static final TrackedData<Map<UUID, BalloonOrder>> ORDER_DATA = TrackedData.Builder.create(ORDER_PROCESSOR, Maps::newHashMap).build();

    public static void registerTrackedData() {
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("endergetic", "ballooon_order"), ORDER_DATA);
    }
}

