/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.bedspreads.common;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import top.theillusivec4.bedspreads.common.DecoratedBedItem;
import top.theillusivec4.bedspreads.common.DecoratedBedsRegistry;

public class DecoratedBedTileEntity
extends TileEntity {
    private ItemStack bed = ItemStack.field_190927_a;
    private ItemStack banner = ItemStack.field_190927_a;
    private DyeColor bannerColor = DyeColor.WHITE;
    private ListNBT patterns;
    private boolean patternDataSet;
    private List<Pair<BannerPattern, DyeColor>> patternList;

    public DecoratedBedTileEntity() {
        super(DecoratedBedsRegistry.DECORATED_BED_TE);
    }

    public void loadFromItemStack(ItemStack stack) {
        CompoundNBT bannernbt;
        this.patterns = null;
        CompoundNBT nbttagcompound = stack.func_179543_a("BlockEntityTag");
        if (nbttagcompound != null) {
            this.bed = ItemStack.func_199557_a((CompoundNBT)nbttagcompound.func_74775_l("BedStack"));
            this.banner = ItemStack.func_199557_a((CompoundNBT)nbttagcompound.func_74775_l("BannerStack"));
            if (!this.banner.func_190926_b()) {
                this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
            }
        }
        if ((bannernbt = this.banner.func_179543_a("BlockEntityTag")) != null && bannernbt.func_150297_b("Patterns", 9)) {
            this.patterns = bannernbt.func_150295_c("Patterns", 10).func_74737_b();
        }
        this.patternList = null;
        this.patternDataSet = true;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.bed.func_190926_b()) {
            compound.func_218657_a("BedStack", (INBT)this.bed.func_77955_b(new CompoundNBT()));
        }
        if (!this.banner.func_190926_b()) {
            compound.func_218657_a("BannerStack", (INBT)this.banner.func_77955_b(new CompoundNBT()));
        }
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState blockState, @Nonnull CompoundNBT compound) {
        CompoundNBT bannernbt;
        super.func_230337_a_(blockState, compound);
        this.bed = compound.func_74764_b("BedStack") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BedStack")) : ItemStack.field_190927_a;
        ItemStack itemStack = this.banner = compound.func_74764_b("BannerStack") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BannerStack")) : ItemStack.field_190927_a;
        if (!this.banner.func_190926_b()) {
            this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
        }
        this.patterns = (bannernbt = this.banner.func_179543_a("BlockEntityTag")) != null ? bannernbt.func_150295_c("Patterns", 10).func_74737_b() : null;
        this.patternList = null;
        this.patternDataSet = true;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 11, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public List<Pair<BannerPattern, DyeColor>> getPatternList() {
        if (this.patternList == null && this.patternDataSet) {
            this.patternList = BannerTileEntity.func_230138_a_((DyeColor)this.getBannerColor(), (ListNBT)this.patterns);
        }
        return this.patternList;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack((IItemProvider)DecoratedBedsRegistry.DECORATED_BED_ITEM);
        CompoundNBT compound = itemstack.func_190925_c("BlockEntityTag");
        if (!this.bed.func_190926_b()) {
            compound.func_218657_a("BedStack", (INBT)this.bed.func_77955_b(new CompoundNBT()));
        }
        if (!this.banner.func_190926_b()) {
            compound.func_218657_a("BannerStack", (INBT)this.banner.func_77955_b(new CompoundNBT()));
        }
        return itemstack;
    }

    public DyeColor getBannerColor() {
        return this.bannerColor;
    }
}

