/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.placebo.Placebo;
import shadows.placebo.net.MessagePatreonDisable;
import shadows.placebo.patreon.PatreonUtils;
import shadows.placebo.patreon.wings.WingLayer;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="placebo", value={Dist.CLIENT})
public class WingsManager {
    static Map<UUID, PatreonUtils.WingType> WINGS = new HashMap<UUID, PatreonUtils.WingType>();
    public static final KeyBinding TOGGLE = new KeyBinding("placebo.toggleWings", 328, "key.categories.placebo");
    public static final Set<UUID> DISABLED = new HashSet<UUID>();

    @SubscribeEvent
    public static void init(FMLClientSetupEvent e) {
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE);
        e.enqueueWork(() -> Minecraft.func_71410_x().func_175598_ae().getSkinMap().values().forEach(r -> r.func_177094_a((LayerRenderer)new WingLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)r))));
        new Thread(() -> {
            Placebo.LOGGER.info("Loading patreon wing data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/Shadows-of-Fire/Placebo/1.16/PatreonWings.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Placebo.LOGGER.error("Invalid patreon wing entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        WINGS.put(UUID.fromString(split[0]), PatreonUtils.WingType.valueOf(split[1]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Placebo.LOGGER.error("Exception loading patreon wing data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Placebo.LOGGER.info("Loaded {} patreon wings.", (Object)WINGS.size());
            if (WINGS.size() > 0) {
                MinecraftForge.EVENT_BUS.addListener(WingsManager::clientTick);
            }
        }, "Placebo Patreon Wing Loader").start();
    }

    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (TOGGLE.func_151468_f()) {
            Placebo.CHANNEL.sendToServer((Object)new MessagePatreonDisable(1));
        }
    }

    public static PatreonUtils.WingType getType(UUID id) {
        return WINGS.get(id);
    }
}

