/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.mixins;

import github.pitbox46.itemblacklist.ItemBlacklist;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Inject(at={@At(value="RETURN")}, method={"getRecipe(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"}, cancellable=true)
    private <C extends IInventory, T extends IRecipe<C>> void onGetRecipe(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<Optional<T>> cir) {
        ((Optional)cir.getReturnValue()).ifPresent(value -> {
            Item items = ((IRecipe)((Optional)cir.getReturnValue()).get()).func_77571_b().func_77973_b();
            cir.setReturnValue(ItemBlacklist.shouldDelete(items.func_190903_i()) ? Optional.empty() : Optional.of(value));
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"getRecipes(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/List;"}, cancellable=true)
    private <C extends IInventory, T extends IRecipe<C>> void onGetRecipes(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<List<T>> cir) {
        cir.setReturnValue(((List)cir.getReturnValue()).stream().filter(entry -> !ItemBlacklist.shouldDelete(entry.func_77572_b(inventoryIn))).collect(Collectors.toList()));
    }
}

