/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.setup.Configuration;

@OnlyIn(value=Dist.CLIENT)
public class ComfortHealthOverlay {
    protected int healthIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE = new ResourceLocation("farmersdelightvco", "textures/gui/fd_icons.png");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ComfortHealthOverlay());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)Configuration.COMFORT_HEALTH_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        this.healthIconsOffset = ForgeIngameGui.left_height;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        boolean isPlayerEligibleForComfort;
        if (!((Boolean)Configuration.COMFORT_HEALTH_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        FoodStats stats = player.func_71024_bL();
        int left = minecraft.func_228018_at_().func_198107_o() / 2 - 91;
        int top = minecraft.func_228018_at_().func_198087_p() - this.healthIconsOffset;
        boolean bl = isPlayerEligibleForComfort = stats.func_75115_e() == 0.0f && player.func_70996_bM() && !player.func_70644_a(Effects.field_76428_l);
        if (player.func_70660_b((Effect)ModEffects.COMFORT.get()) != null && isPlayerEligibleForComfort) {
            ComfortHealthOverlay.drawComfortOverlay((PlayerEntity)player, minecraft, event.getMatrixStack(), left, top);
        }
    }

    public static void drawComfortOverlay(PlayerEntity player, Minecraft minecraft, MatrixStack matrixStack, int left, int top) {
        int ticks = minecraft.field_71456_v.func_73834_c();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        ModifiableAttributeInstance attrMaxHealth = player.func_110148_a(Attributes.field_233818_a_);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        int regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            regen = ticks % 25;
        }
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int comfortSheen = ticks % 50;
        int comfortHeartFrame = comfortSheen % 2;
        int[] textureWidth = new int[]{5, 9};
        minecraft.func_110434_K().func_110577_a(MOD_ICONS_TEXTURE);
        RenderSystem.enableBlend();
        int totalHealth = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f));
        for (int i = totalHealth - 1; i >= 0; --i) {
            int column = i % 10;
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + column * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            if (column == comfortSheen / 2) {
                minecraft.field_71456_v.func_238474_b_(matrixStack, x, y, 0, 9, textureWidth[comfortHeartFrame], 9);
            }
            if (column != comfortSheen / 2 - 1 || comfortHeartFrame != 0) continue;
            minecraft.field_71456_v.func_238474_b_(matrixStack, x + 5, y, 5, 9, 4, 9);
        }
        RenderSystem.disableBlend();
        minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }
}

