/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import vectorwing.farmersdelight.tile.container.CookingPotContainer;
import vectorwing.farmersdelight.utils.TextUtils;

@ParametersAreNonnullByDefault
public class CookingPotScreen
extends ContainerScreen<CookingPotContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("farmersdelightvco", "textures/gui/cooking_pot.png");
    private static final Rectangle HEAT_ICON = new Rectangle(47, 55, 17, 15);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 25, 0, 17);

    public CookingPotScreen(CookingPotContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.field_238742_p_ = 28;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.renderMealDisplayTooltip(ms, mouseX, mouseY);
        this.renderHeatIndicatorTooltip(ms, mouseX, mouseY);
    }

    private void renderHeatIndicatorTooltip(MatrixStack ms, int mouseX, int mouseY) {
        if (this.func_195359_a(CookingPotScreen.HEAT_ICON.x, CookingPotScreen.HEAT_ICON.y, CookingPotScreen.HEAT_ICON.width, CookingPotScreen.HEAT_ICON.height, mouseX, mouseY)) {
            ArrayList<IFormattableTextComponent> tooltip = new ArrayList<IFormattableTextComponent>();
            String key = "container.cooking_pot." + (((CookingPotContainer)this.field_147002_h).isHeated() ? "heated" : "not_heated");
            tooltip.add(TextUtils.getTranslation(key, this.field_147002_h));
            this.func_243308_b(ms, tooltip, mouseX, mouseY);
        }
    }

    protected void renderMealDisplayTooltip(MatrixStack ms, int mouseX, int mouseY) {
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null && this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_147006_u.field_75222_d == 6) {
                ArrayList<IFormattableTextComponent> tooltip = new ArrayList<IFormattableTextComponent>();
                ItemStack mealStack = this.field_147006_u.func_75211_c();
                tooltip.add(((IFormattableTextComponent)mealStack.func_77973_b().func_200296_o()).func_240699_a_(mealStack.func_77953_t().field_77937_e));
                ItemStack containerStack = ((CookingPotContainer)this.field_147002_h).tileEntity.getContainer();
                String container = !containerStack.func_190926_b() ? containerStack.func_77973_b().func_200296_o().getString() : "";
                tooltip.add(TextUtils.getTranslation("container.cooking_pot.served_on", container).func_240699_a_(TextFormatting.GRAY));
                this.func_243308_b(ms, tooltip, mouseX, mouseY);
            } else {
                this.func_230457_a_(ms, this.field_147006_u.func_75211_c(), mouseX, mouseY);
            }
        }
    }

    protected void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        super.func_230451_b_(ms, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(ms, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_230706_i_ == null) {
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_238474_b_(ms, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((CookingPotContainer)this.field_147002_h).isHeated()) {
            this.func_238474_b_(ms, this.field_147003_i + CookingPotScreen.HEAT_ICON.x, this.field_147009_r + CookingPotScreen.HEAT_ICON.y, 176, 0, CookingPotScreen.HEAT_ICON.width, CookingPotScreen.HEAT_ICON.height);
        }
        int l = ((CookingPotContainer)this.field_147002_h).getCookProgressionScaled();
        this.func_238474_b_(ms, this.field_147003_i + CookingPotScreen.PROGRESS_ARROW.x, this.field_147009_r + CookingPotScreen.PROGRESS_ARROW.y, 176, 15, l + 1, CookingPotScreen.PROGRESS_ARROW.height);
    }
}

