/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.potion.Effect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.setup.Configuration;

@OnlyIn(value=Dist.CLIENT)
public class NourishedHungerOverlay {
    protected int foodIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE = new ResourceLocation("farmersdelightvco", "textures/gui/fd_icons.png");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new NourishedHungerOverlay());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)Configuration.NOURISHED_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        this.foodIconsOffset = ForgeIngameGui.right_height;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        boolean isPlayerHealingWithSaturation;
        if (!((Boolean)Configuration.NOURISHED_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        FoodStats stats = player.func_71024_bL();
        int left = minecraft.func_228018_at_().func_198107_o() / 2 + 91;
        int top = minecraft.func_228018_at_().func_198087_p() - this.foodIconsOffset;
        boolean bl = isPlayerHealingWithSaturation = player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i) && player.func_70996_bM() && stats.func_75115_e() > 0.0f && stats.func_75116_a() >= 20;
        if (player.func_70660_b((Effect)ModEffects.NOURISHED.get()) != null) {
            NourishedHungerOverlay.drawNourishedOverlay(stats, minecraft, event.getMatrixStack(), left, top, isPlayerHealingWithSaturation);
        }
    }

    public static void drawNourishedOverlay(FoodStats stats, Minecraft mc, MatrixStack matrixStack, int left, int top, boolean naturalHealing) {
        float saturation = stats.func_75115_e();
        int foodLevel = stats.func_75116_a();
        int ticks = mc.field_71456_v.func_73834_c();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        mc.func_110434_K().func_110577_a(MOD_ICONS_TEXTURE);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int naturalHealingOffset;
            int x = left - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, 0, 0, 9, 9);
            float effectiveHungerOfBar = (float)stats.func_75116_a() / 2.0f - (float)j;
            int n = naturalHealingOffset = naturalHealing ? 18 : 0;
            if (effectiveHungerOfBar >= 1.0f) {
                mc.field_71456_v.func_238474_b_(matrixStack, x, y, 18 + naturalHealingOffset, 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, 9 + naturalHealingOffset, 0, 9, 9);
        }
        RenderSystem.disableBlend();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }
}

