/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;

public class ActionRemoveCuttingBoardRecipe
extends ActionRecipeBase {
    private final IItemStack[] outputs;

    public ActionRemoveCuttingBoardRecipe(IRecipeManager manager, IItemStack[] outputs) {
        super(manager);
        this.outputs = outputs;
    }

    public void apply() {
        Iterator it = this.getManager().getRecipes().entrySet().iterator();
        block0: while (it.hasNext()) {
            CuttingBoardRecipe recipe = (CuttingBoardRecipe)it.next().getValue();
            if (recipe.getResults().size() != this.outputs.length) continue;
            int i = 0;
            for (ItemStack result : recipe.getResults()) {
                if (this.outputs[i++].matches((IItemStack)new MCItemStackMutable(result))) continue;
                continue block0;
            }
            it.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + Arrays.toString(this.outputs) + "\"";
    }

    public boolean validate(ILogger logger) {
        if (this.outputs == null) {
            logger.throwingWarn("output cannot be null!", (Throwable)new ScriptException("output IItemStacks cannot be null!"));
            return false;
        }
        return true;
    }
}

