/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.decomposition;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vectorwing.farmersdelight.integration.jei.decomposition.DecompositionDummy;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.utils.tags.ModTags;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecompositionRecipeCategory
implements IRecipeCategory<DecompositionDummy> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelightvco", "decomposition");
    private static final int slotSize = 22;
    private final String title = I18n.func_135052_a((String)"farmersdelightvco.jei.decomposition", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable slotIcon;
    private final IDrawable icon;
    private final ItemStack organicCompost;
    private final ItemStack richSoil;

    public DecompositionRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelightvco", "textures/gui/jei/decomposition.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 118, 80);
        this.organicCompost = new ItemStack((IItemProvider)ModBlocks.ORGANIC_COMPOST.get());
        this.richSoil = new ItemStack((IItemProvider)ModItems.RICH_SOIL.get());
        this.icon = helper.createDrawableIngredient((Object)this.richSoil);
        this.slotIcon = helper.createDrawable(backgroundImage, 119, 0, 22, 22);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DecompositionDummy> getRecipeClass() {
        return DecompositionDummy.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DecompositionDummy decompositionRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)ImmutableList.of((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.organicCompost})));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.richSoil);
    }

    public void setRecipe(IRecipeLayout recipeLayout, DecompositionDummy decompositionRecipe, IIngredients iIngredients) {
        List accelerators = ModTags.COMPOST_ACTIVATORS.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList());
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 8, 25);
        itemStacks.set(0, this.organicCompost);
        itemStacks.init(1, false, 92, 25);
        itemStacks.set(1, this.richSoil);
        itemStacks.init(2, false, 63, 53);
        itemStacks.set(2, accelerators);
    }

    public void draw(DecompositionDummy recipe, MatrixStack ms, double mouseX, double mouseY) {
        this.slotIcon.draw(ms, 63, 53);
    }

    public List<ITextComponent> getTooltipStrings(DecompositionDummy recipe, double mouseX, double mouseY) {
        if (DecompositionRecipeCategory.inIconAt(40, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".light"));
        }
        if (DecompositionRecipeCategory.inIconAt(53, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".fluid"));
        }
        if (DecompositionRecipeCategory.inIconAt(67, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".accelerators"));
        }
        return Collections.emptyList();
    }

    private static boolean inIconAt(int iconX, int iconY, double mouseX, double mouseY) {
        int icon_size = 11;
        return (double)iconX <= mouseX && mouseX < (double)(iconX + 11) && (double)iconY <= mouseY && mouseY < (double)(iconY + 11);
    }

    private static TranslationTextComponent translateKey(@Nonnull String suffix) {
        return new TranslationTextComponent("farmersdelightvco.jei.decomposition" + suffix);
    }
}

