/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.items;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.registry.ModParticleTypes;
import vectorwing.farmersdelight.setup.Configuration;
import vectorwing.farmersdelight.utils.MathUtils;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class HorseFeedItem
extends Item {
    public static final List<EffectInstance> EFFECTS = Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76424_c, 6000, 1), new EffectInstance(Effects.field_76430_j, 6000, 0)});

    public HorseFeedItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        IFormattableTextComponent textWhenFeeding = TextUtils.getTranslation("tooltip.horse_feed.when_feeding", new Object[0]);
        tooltip.add((ITextComponent)textWhenFeeding.func_240699_a_(TextFormatting.GRAY));
        for (EffectInstance effectInstance : EFFECTS) {
            StringTextComponent effectDescription = new StringTextComponent(" ");
            TranslationTextComponent effectName = new TranslationTextComponent(effectInstance.func_76453_d());
            effectDescription.func_230529_a_((ITextComponent)effectName);
            Effect effect = effectInstance.func_188419_a();
            if (effectInstance.func_76458_c() > 0) {
                effectDescription.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + effectInstance.func_76458_c()));
            }
            if (effectInstance.func_76459_b() > 20) {
                effectDescription.func_240702_b_(" (").func_240702_b_(EffectUtils.func_188410_a((EffectInstance)effectInstance, (float)1.0f)).func_240702_b_(")");
            }
            tooltip.add((ITextComponent)effectDescription.func_240699_a_(effect.func_220303_e().func_220306_a()));
        }
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        HorseEntity horse;
        if (target instanceof HorseEntity && (horse = (HorseEntity)target).func_70089_S() && horse.func_110248_bS()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Mod.EventBusSubscriber(modid="farmersdelightvco", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class HorseFeedEvent {
        @SubscribeEvent
        public static void onHorseFeedApplied(PlayerInteractEvent.EntityInteract event) {
            PlayerEntity player = event.getPlayer();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity && ModTags.HORSE_FEED_USERS.func_230235_a_((Object)target.func_200600_R())) {
                LivingEntity entity = (LivingEntity)target;
                boolean isTameable = entity instanceof AbstractHorseEntity;
                if (entity.func_70089_S() && (!isTameable || ((AbstractHorseEntity)entity).func_110248_bS()) && itemStack.func_77973_b().equals(ModItems.HORSE_FEED.get())) {
                    entity.func_70606_j(entity.func_110138_aP());
                    for (EffectInstance effect : EFFECTS) {
                        entity.func_195064_c(new EffectInstance(effect));
                    }
                    entity.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187711_cp, SoundCategory.PLAYERS, 0.8f, 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                        double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                        double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                        entity.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.STAR.get(), entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), d0, d1, d2);
                    }
                    if (!player.func_184812_l_()) {
                        itemStack.func_190918_g(1);
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }
}

