/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.blocks.SkilletBlock;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.tile.SkilletTileEntity;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class SkilletItem
extends BlockItem {
    public static final ItemTier SKILLET_TIER = ItemTier.IRON;
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public SkilletItem(Block blockIn, Item.Properties builderIn) {
        super(blockIn, builderIn.func_200915_b(SKILLET_TIER.func_200926_a()));
        float attackDamage = 4.0f + SKILLET_TIER.func_200929_c();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)-3.1f, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    private static boolean isPlayerNearHeatSource(PlayerEntity player, IWorldReader worldIn) {
        if (player.func_70027_ad()) {
            return true;
        }
        BlockPos pos = player.func_233580_cy_();
        for (BlockPos nearbyPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            if (!worldIn.func_180495_p(nearbyPos).func_235714_a_(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        int fireAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
        int cookingTime = stack.func_196082_o().func_74762_e("CookTimeHandheld");
        return SkilletBlock.getSkilletCookingTime(cookingTime, fireAspectLevel);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack skilletStack = player.func_184586_b(hand);
        if (SkilletItem.isPlayerNearHeatSource(player, (IWorldReader)world)) {
            Hand otherHand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
            ItemStack cookingStack = player.func_184586_b(otherHand);
            if (skilletStack.func_196082_o().func_74764_b("Cooking")) {
                player.func_184598_c(hand);
                return ActionResult.func_226250_c_((Object)skilletStack);
            }
            Optional<CampfireCookingRecipe> recipe = SkilletItem.getCookingRecipe(cookingStack, world);
            if (recipe.isPresent()) {
                ItemStack cookingStackCopy = cookingStack.func_77946_l();
                ItemStack cookingStackUnit = cookingStackCopy.func_77979_a(1);
                skilletStack.func_196082_o().func_218657_a("Cooking", (INBT)cookingStackUnit.serializeNBT());
                skilletStack.func_196082_o().func_74768_a("CookTimeHandheld", recipe.get().func_222137_e());
                player.func_184598_c(hand);
                player.func_184611_a(otherHand, cookingStackCopy);
                return ActionResult.func_226249_b_((Object)skilletStack);
            }
            player.func_146105_b((ITextComponent)TextUtils.getTranslation("item.skillet.how_to_cook", new Object[0]), true);
        }
        return ActionResult.func_226250_c_((Object)skilletStack);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (livingEntityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntityIn;
            Vector3d pos = player.func_213303_ch();
            double x = pos.func_82615_a() + 0.5;
            double y = pos.func_82617_b();
            double z = pos.func_82616_c() + 0.5;
            if (worldIn.field_73012_v.nextInt(50) == 0) {
                worldIn.func_184134_a(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundCategory.BLOCKS, 0.4f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Cooking")) {
            ItemStack cookingStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Cooking"));
            player.field_71071_by.func_191975_a(worldIn, cookingStack);
            tag.func_82580_o("Cooking");
            tag.func_82580_o("CookTimeHandheld");
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Cooking")) {
            ItemStack cookingStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Cooking"));
            Optional<CampfireCookingRecipe> cookingRecipe = SkilletItem.getCookingRecipe(cookingStack, world);
            cookingRecipe.ifPresent(recipe -> {
                ItemStack resultStack = recipe.func_77572_b((IInventory)new Inventory(new ItemStack[0]));
                if (!player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
                }
            });
            tag.func_82580_o("Cooking");
            tag.func_82580_o("CookTimeHandheld");
        }
        return stack;
    }

    public static Optional<CampfireCookingRecipe> getCookingRecipe(ItemStack stack, World world) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        return world.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)new Inventory(new ItemStack[]{stack}), world);
    }

    protected boolean func_195943_a(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        super.func_195943_a(pos, worldIn, player, stack, state);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof SkilletTileEntity) {
            ((SkilletTileEntity)tileEntity).setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return SKILLET_TIER.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            return super.func_195942_a(context);
        }
        return ActionResultType.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.field_77351_y.equals((Object)EnchantmentType.WEAPON)) {
            HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.field_191530_r});
            return !DENIED_ENCHANTMENTS.contains(enchantment);
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public int func_77619_b() {
        return SKILLET_TIER.func_200927_e();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.toolAttributes : super.func_111205_h(equipmentSlot);
    }

    @Mod.EventBusSubscriber(modid="farmersdelightvco", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SkilletEvents {
        @SubscribeEvent
        public static void onSkilletKnockback(LivingKnockBackEvent event) {
            ItemStack tool;
            LivingEntity attacker = event.getEntityLiving().func_94060_bK();
            ItemStack itemStack = tool = attacker != null ? attacker.func_184586_b(Hand.MAIN_HAND) : ItemStack.field_190927_a;
            if (tool.func_77973_b() instanceof SkilletItem) {
                event.setStrength(event.getOriginalStrength() * 2.0f);
            }
        }

        @SubscribeEvent
        public static void onSkilletAttack(AttackEntityEvent event) {
            PlayerEntity player = event.getPlayer();
            float attackPower = player.func_184825_o(0.0f);
            ItemStack tool = player.func_184586_b(Hand.MAIN_HAND);
            if (tool.func_77973_b() instanceof SkilletItem) {
                if (attackPower > 0.8f) {
                    float pitch = 0.9f + field_77697_d.nextFloat() * 0.2f;
                    player.func_130014_f_().func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), SoundCategory.PLAYERS, 1.0f, pitch);
                } else {
                    player.func_130014_f_().func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_WEAK.get(), SoundCategory.PLAYERS, 0.8f, 0.9f);
                }
            }
        }
    }
}

