/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.loot.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemModifier
extends LootModifier {
    private final Item addedItem;
    private final int count;

    protected AddItemModifier(ILootCondition[] conditionsIn, Item addedItemIn, int count) {
        super(conditionsIn);
        this.addedItem = addedItemIn;
        this.count = count;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack addedStack = new ItemStack((IItemProvider)this.addedItem, this.count);
        if (addedStack.func_190916_E() < addedStack.func_77976_d()) {
            generatedLoot.add(addedStack);
        } else {
            ItemStack subStack;
            for (int i = addedStack.func_190916_E(); i > 0; i -= subStack.func_190916_E()) {
                subStack = addedStack.func_77946_l();
                subStack.func_190920_e(Math.min(addedStack.func_77976_d(), i));
                generatedLoot.add(subStack);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemModifier> {
        public AddItemModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            Item addedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"item")));
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            return new AddItemModifier(conditions, addedItem, count);
        }

        public JsonObject write(AddItemModifier instance) {
            return new JsonObject();
        }
    }
}

