/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.setup;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;

@Mod.EventBusSubscriber(modid="farmersdelightvco")
public class RemappingHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MULCH = new ResourceLocation("farmersdelightvco", "mulch");
    private static final ResourceLocation MULCH_FARMLAND = new ResourceLocation("farmersdelightvco", "mulch_farmland");

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        ModContainer mod = (ModContainer)ModList.get().getModContainerById("farmersdelightvco").get();
        event.setModContainer(mod);
        ImmutableList mappings = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            if (mapping.key.equals((Object)MULCH)) {
                mapping.remap((IForgeRegistryEntry)((Block)ModBlocks.RICH_SOIL.get()));
                LOGGER.warn("Remapping block '{}' to '{}'...", (Object)MULCH, (Object)((Block)ModBlocks.RICH_SOIL.get()).getRegistryName());
            }
            if (!mapping.key.equals((Object)MULCH_FARMLAND)) continue;
            mapping.remap((IForgeRegistryEntry)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()));
            LOGGER.warn("Remapping block '{}' to '{}'...", (Object)MULCH_FARMLAND, (Object)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).getRegistryName());
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        ModContainer mod = (ModContainer)ModList.get().getModContainerById("farmersdelightvco").get();
        event.setModContainer(mod);
        ImmutableList mappings = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            if (mapping.key.equals((Object)MULCH)) {
                mapping.remap((IForgeRegistryEntry)((Item)ModItems.RICH_SOIL.get()));
                LOGGER.warn("Remapping item '{}' to '{}'...", (Object)MULCH, (Object)((Block)ModBlocks.RICH_SOIL.get()).getRegistryName());
            }
            if (!mapping.key.equals((Object)MULCH_FARMLAND)) continue;
            mapping.remap((IForgeRegistryEntry)((Item)ModItems.RICH_SOIL_FARMLAND.get()));
            LOGGER.warn("Remapping item '{}' to '{}'...", (Object)MULCH_FARMLAND, (Object)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).getRegistryName());
        }
    }
}

