/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import vice.magnesium_extras.config.ConfigBuilder;

public class MagnesiumExtrasConfig {
    public static ForgeConfigSpec ConfigSpec;
    public static ForgeConfigSpec.ConfigValue<String> fadeInQuality;
    public static ForgeConfigSpec.ConfigValue<String> fpsCounterMode;
    public static ForgeConfigSpec.ConfigValue<Integer> fpsCounterPosition;
    public static ForgeConfigSpec.ConfigValue<Integer> cloudHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> maxTileEntityRenderDistanceSquare;
    public static ForgeConfigSpec.ConfigValue<Integer> maxTileEntityRenderDistanceY;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntityRenderDistanceSquare;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntityRenderDistanceY;
    public static ForgeConfigSpec.ConfigValue<Boolean> fog;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableDistanceChecks;
    public static ZoomValues zoomValues;
    public static ForgeConfigSpec.ConfigValue<Boolean> lowerZoomSensitivity;
    public static ForgeConfigSpec.ConfigValue<String> zoomTransition;
    public static ForgeConfigSpec.ConfigValue<String> zoomMode;
    public static ForgeConfigSpec.ConfigValue<String> cinematicCameraMode;
    public static ForgeConfigSpec.ConfigValue<Boolean> zoomScrolling;
    public static ForgeConfigSpec.ConfigValue<Boolean> zoomOverlay;
    public static ForgeConfigSpec.EnumValue<FullscreenMode> fullScreenMode;
    public static double darkNetherFogEffective;
    public static double darkEndFogEffective;
    public static ForgeConfigSpec.BooleanValue trueDarknessEnabled;
    public static ForgeConfigSpec.EnumValue<DarknessOption> darknessOption;
    public static ForgeConfigSpec.DoubleValue darkNetherFogConfigured;
    public static ForgeConfigSpec.BooleanValue darkEnd;
    public static ForgeConfigSpec.DoubleValue darkEndFogConfigured;
    public static ForgeConfigSpec.BooleanValue darkSkyless;
    public static ForgeConfigSpec.BooleanValue blockLightOnly;
    public static ForgeConfigSpec.BooleanValue ignoreMoonPhase;
    public static ForgeConfigSpec.DoubleValue minimumMoonLevel;
    public static ForgeConfigSpec.DoubleValue maximumMoonLevel;
    public static ForgeConfigSpec.BooleanValue darkOverworld;
    public static ForgeConfigSpec.BooleanValue darkDefault;
    public static ForgeConfigSpec.BooleanValue darkNether;

    public static void loadConfig(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ConfigSpec.setConfig((CommentedConfig)configData);
    }

    static {
        zoomValues = new ZoomValues();
        ConfigBuilder builder = new ConfigBuilder("Dynamic Lights Settings");
        builder.Block("Misc", b -> {
            cloudHeight = b.define("Cloud Height [Raw, Default 196]", (Object)196);
            fadeInQuality = b.define("Chunk Fade In Quality (OFF, FAST, FANCY)", (Object)"FANCY");
            fog = b.define("Render Fog", true);
            fullScreenMode = b.defineEnum("Use Borderless Fullscreen", (Enum)FullscreenMode.FULLSCREEN);
        });
        builder.Block("FPS Counter", b -> {
            fpsCounterMode = b.define("Display FPS Counter (OFF, SIMPLE, ADVANCED)", (Object)"ADVANCED");
            fpsCounterPosition = b.define("FPS Counter Distance", (Object)12);
        });
        builder.Block("Entity Distance", b -> {
            enableDistanceChecks = b.define("Enable Max Distance Checks", true);
            maxTileEntityRenderDistanceSquare = b.define("(TileEntity) Max Horizontal Render Distance [Squared, Default 64^2]", (Object)4096);
            maxTileEntityRenderDistanceY = b.define("(TileEntity) Max Vertical Render Distance [Raw, Default 32]", (Object)32);
            maxEntityRenderDistanceSquare = b.define("(Entity) Max Horizontal Render Distance [Squared, Default 64^2]", (Object)4096);
            maxEntityRenderDistanceY = b.define("(Entity) Max Vertical Render Distance [Raw, Default 32]", (Object)32);
        });
        builder.Block("Zoom", b -> {
            lowerZoomSensitivity = b.define("Lower Zoom Sensitivity", true);
            zoomScrolling = b.define("Zoom Scrolling Enabled", true);
            zoomTransition = b.define("Zoom Transition Mode (OFF, LINEAR, SMOOTH)", (Object)ZoomTransitionOptions.SMOOTH.toString());
            zoomMode = b.define("Zoom Transition Mode (TOGGLE, HOLD, PERSISTENT)", (Object)ZoomModes.HOLD.toString());
            cinematicCameraMode = b.define("Cinematic Camera Mode (OFF, VANILLA, MULTIPLIED)", (Object)CinematicCameraOptions.OFF.toString());
            zoomOverlay = b.define("Zoom Overlay?", true);
        });
        builder.Block("True Darkness", b -> {
            trueDarknessEnabled = b.define("Use True Darkness", true);
            darknessOption = b.defineEnum("Darkness Setting (PITCH_BLACK, REALLY_DARK, DARK, DIM)", (Enum)DarknessOption.DARK);
            builder.Block("Advanced", b2 -> {
                blockLightOnly = b2.define("Only Effect Block Lighting", false);
                ignoreMoonPhase = b2.define("Ignore Moon Light", false);
                minimumMoonLevel = b2.defineInRange("Minimum Moon Brightness (0->1)", 0.0, 0.0, 1.0);
                maximumMoonLevel = b2.defineInRange("Maximum Moon Brightness (0->1)", 0.25, 0.0, 1.0);
            });
            builder.Block("Dimension Settings", b2 -> {
                darkOverworld = b2.define("Dark Overworld?", true);
                darkDefault = b2.define("Dark By Default?", false);
                darkNether = b2.define("Dark Nether?", false);
                darkNetherFogConfigured = b2.defineInRange("Dark Nether Fog Brightness (0->1)", 0.5, 0.0, 1.0);
                darkEnd = b2.define("Dark End?", false);
                darkEndFogConfigured = b.defineInRange("Dark End Fog Brightness (0->1)", 0.0, 0.0, 1.0);
                darkSkyless = b2.define("Dark If No Skylight?", false);
            });
        });
        ConfigSpec = builder.Save();
    }

    public static class ZoomValues {
        public double zoomDivisor = 4.0;
        public double minimumZoomDivisor = 1.0;
        public double maximumZoomDivisor = 50.0;
        public double scrollStep = 1.0;
        public double lesserScrollStep = 0.5;
        public double cinematicMultiplier = 4.0;
        public double smoothMultiplier = 0.75;
        public double minimumLinearStep = 0.125;
        public double maximumLinearStep = 0.25;
    }

    public static enum CinematicCameraOptions {
        OFF,
        VANILLA,
        MULTIPLIED;

    }

    public static enum ZoomModes {
        HOLD,
        TOGGLE,
        PERSISTENT;

    }

    public static enum ZoomTransitionOptions {
        OFF,
        SMOOTH;

    }

    public static enum FullscreenMode {
        WINDOWED,
        BORDERLESS,
        FULLSCREEN;

    }

    public static enum DarknessOption {
        PITCH_BLACK(0.0f),
        REALLY_DARK(0.04f),
        DARK(0.08f),
        DIM(0.12f);

        public final float value;

        private DarknessOption(float value) {
            this.value = value;
        }
    }

    public static enum Quality implements TextProvider
    {
        OFF("Off"),
        FAST("Fast"),
        FANCY("Fancy");

        private final String name;

        private Quality(String name) {
            this.name = name;
        }

        public String getLocalizedName() {
            return this.name;
        }
    }

    public static enum Complexity implements TextProvider
    {
        OFF("Off"),
        SIMPLE("Simple"),
        ADVANCED("Advanced");

        private final String name;

        private Complexity(String name) {
            this.name = name;
        }

        public String getLocalizedName() {
            return this.name;
        }
    }
}

