/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.FrameCounter;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;
import vice.magnesium_extras.features.FrameCounter.MinFrameProvider;
import vice.magnesium_extras.mixins.FrameCounter.FpsAccessorMixin;

@Mixin(value={ForgeIngameGui.class})
public class FrameCounterMixin {
    private int lastMeasuredFPS;
    private String runningAverageFPS;
    private final Queue<Integer> fpsRunningAverageQueue = new LinkedList<Integer>();

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(MatrixStack matrixStack, float tickDelta, CallbackInfo info) {
        if (Objects.equals(MagnesiumExtrasConfig.fpsCounterMode.get(), "OFF")) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71474_y.field_74330_P && !client.field_71474_y.field_181657_aC) {
            return;
        }
        String displayString = null;
        int fps = FpsAccessorMixin.getFPS();
        displayString = Objects.equals(MagnesiumExtrasConfig.fpsCounterMode.get(), "ADVANCED") ? this.GetAdvancedFPSString(fps) : String.valueOf(fps);
        float textPos = ((Integer)MagnesiumExtrasConfig.fpsCounterPosition.get()).intValue();
        int textAlpha = 200;
        int textColor = 0xFFFFFF;
        float fontScale = 0.75f;
        double guiScale = client.func_228018_at_().func_198100_s();
        if (guiScale > 0.0) {
            textPos = (float)((double)textPos / guiScale);
        }
        float maxTextPosX = client.func_228018_at_().func_198107_o() - client.field_71466_p.func_78256_a(displayString);
        int n = client.func_228018_at_().func_198087_p();
        client.field_71466_p.getClass();
        float maxTextPosY = n - 9;
        textPos = Math.min(textPos, maxTextPosX);
        int drawColor = (textAlpha & 0xFF) << 24 | textColor;
        if (client.func_228018_at_().func_198100_s() > 3.0) {
            GL11.glPushMatrix();
            GL11.glScalef((float)fontScale, (float)fontScale, (float)fontScale);
            client.field_71466_p.func_238405_a_(matrixStack, displayString, textPos, textPos, drawColor);
            GL11.glPopMatrix();
        } else {
            client.field_71466_p.func_238405_a_(matrixStack, displayString, textPos, textPos, drawColor);
        }
    }

    private String GetAdvancedFPSString(int fps) {
        MinFrameProvider.recalculate();
        if (this.lastMeasuredFPS != fps) {
            this.lastMeasuredFPS = fps;
            if (this.fpsRunningAverageQueue.size() > 14) {
                this.fpsRunningAverageQueue.poll();
            }
            this.fpsRunningAverageQueue.offer(fps);
            int totalFps = 0;
            int frameCount = 0;
            for (Integer frameTime : this.fpsRunningAverageQueue) {
                totalFps += frameTime.intValue();
                ++frameCount;
            }
            int average = totalFps / frameCount;
            this.runningAverageFPS = String.valueOf(average);
        }
        return fps + " | MIN " + MinFrameProvider.getLastMinFrame() + " | AVG " + this.runningAverageFPS;
    }
}

