/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.SodiumConfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;
import vice.magnesium_extras.mixins.BorderlessFullscreen.MainWindowAccessor;

@Mixin(value={SodiumGameOptionPages.class})
public class SodiumGameOptionsMixin {
    @Shadow
    @Final
    private static SodiumOptionsStorage sodiumOpts;
    @Shadow
    @Final
    private static MinecraftOptionsStorage vanillaOpts;

    @Inject(method={"general"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true)
    private static void InjectGeneral(CallbackInfoReturnable<OptionPage> cir, List<OptionGroup> groups) {
        OptionImpl fullscreenMode = OptionImpl.createBuilder(MagnesiumExtrasConfig.FullscreenMode.class, (OptionStorage)vanillaOpts).setName("Fullscreen Mode").setTooltip("Windowed - the game will display in a small window.\nBorderless - the game will be fullscreened, and locked to your monitor's refresh rate, but allow you to tab out easily.\nFullscreen - the game will display in native fullscreen mode.").setControl(opt -> new CyclingControl((Option)opt, MagnesiumExtrasConfig.FullscreenMode.class, new String[]{"Windowed", "Borderless", "Fullscreen"})).setBinding((opts, value) -> {
            MagnesiumExtrasConfig.fullScreenMode.set((Object)value);
            opts.field_74353_u = value != MagnesiumExtrasConfig.FullscreenMode.WINDOWED;
            Minecraft client = Minecraft.func_71410_x();
            MainWindow window = client.func_228018_at_();
            if (window != null && window.func_198113_j() != opts.field_74353_u) {
                window.func_198077_g();
                opts.field_74353_u = window.func_198113_j();
            }
            if (window != null && opts.field_74353_u) {
                ((MainWindowAccessor)window).setDirty(true);
                window.func_198097_f();
            }
        }, opts -> (MagnesiumExtrasConfig.FullscreenMode)((Object)((Object)MagnesiumExtrasConfig.fullScreenMode.get()))).build();
        SodiumGameOptionsMixin.ReplaceOption(groups, "Fullscreen", fullscreenMode);
    }

    private static void ReplaceOption(List<OptionGroup> groups, String name, Option<?> replaceOption) {
        ArrayList<OptionGroup> newList = new ArrayList<OptionGroup>();
        for (OptionGroup optionGroup : groups) {
            OptionGroup.Builder builder = OptionGroup.createBuilder();
            for (Option option : optionGroup.getOptions()) {
                builder.add(Objects.equals(option.getName(), name) ? replaceOption : option);
            }
            newList.add(builder.build());
        }
        groups.clear();
        groups.addAll(newList);
    }

    @ModifyConstant(method={"advanced"}, remap=false, constant={@Constant(stringValue="Experimental")})
    private static String ChangeCategoryName(String old) {
        return "Extras";
    }
}

