/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.SodiumConfig;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.gui.screen.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;

@Pseudo
@Mixin(value={SodiumOptionsGUI.class})
public abstract class SodiumSettingsMixin {
    @Shadow
    @Final
    private List<OptionPage> pages;
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void DynamicLights(Screen prevScreen, CallbackInfo ci) {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl displayFps = OptionImpl.createBuilder(MagnesiumExtrasConfig.Complexity.class, (OptionStorage)sodiumOpts).setName("Display FPS").setTooltip("Displays the current FPS. Advanced mode also displays minimum FPS, as well as 15 second average FPS, which are more useful for judging performance.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.Complexity.class, new String[]{"Off", "Simple", "Advanced"})).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterMode.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.Complexity.valueOf((String)MagnesiumExtrasConfig.fpsCounterMode.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl displayFpsPos = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("FPS Display Position").setTooltip("Offsets the FPS display a few pixels").setControl(option -> new SliderControl((Option)option, 4, 64, 2, ControlValueFormatter.quantity((String)"Pixels"))).setImpact(OptionImpact.LOW).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterPosition.set(value), opts -> (Integer)MagnesiumExtrasConfig.fpsCounterPosition.get()).build();
        groups.add(OptionGroup.createBuilder().add((Option)displayFps).add((Option)displayFpsPos).build());
        OptionImpl totalDarkness = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("True Darkness").setTooltip("Makes the rest of the world more realistically dark. Does not effect daytime or torch light.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.trueDarknessEnabled.set(value), options -> (Boolean)MagnesiumExtrasConfig.trueDarknessEnabled.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl totalDarknessSetting = OptionImpl.createBuilder(MagnesiumExtrasConfig.DarknessOption.class, (OptionStorage)sodiumOpts).setName("True Darkness Mode").setTooltip("Controls how dark is considered true darkness.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.DarknessOption.class, new String[]{"Pitch Black", "Really Dark", "Dark", "Dim"})).setBinding((opts, value) -> MagnesiumExtrasConfig.darknessOption.set((Object)value), opts -> (MagnesiumExtrasConfig.DarknessOption)((Object)((Object)MagnesiumExtrasConfig.darknessOption.get()))).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)totalDarkness).add((Option)totalDarknessSetting).build());
        OptionImpl fadeInQuality = OptionImpl.createBuilder(MagnesiumExtrasConfig.Quality.class, (OptionStorage)sodiumOpts).setName("Chunk Fade In Quality").setTooltip("Controls how fast chunks fade in. No performance hit, Fancy simply takes longer, but looks a bit cooler.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.Quality.class, new String[]{"Off", "Fast", "Fancy"})).setBinding((opts, value) -> MagnesiumExtrasConfig.fadeInQuality.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.Quality.valueOf((String)MagnesiumExtrasConfig.fadeInQuality.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl fog = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Enable fog").setTooltip("Toggles off all fog in the overworld.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.fog.set(value), options -> (Boolean)MagnesiumExtrasConfig.fog.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl cloudHeight = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Cloud Height").setTooltip("Raises cloud height.").setControl(option -> new SliderControl((Option)option, 64, 256, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.cloudHeight.set(value), options -> (Integer)MagnesiumExtrasConfig.cloudHeight.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)fadeInQuality).add((Option)fog).add((Option)cloudHeight).build());
        OptionImpl enableDistanceChecks = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Enable Max Entity Distance").setTooltip("Toggles off entity culling.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.enableDistanceChecks.set(value), options -> (Boolean)MagnesiumExtrasConfig.enableDistanceChecks.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)enableDistanceChecks).build());
        OptionImpl maxEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Max Entity Distance").setTooltip("Hides and does not tick entities beyond this many blocks. Huge performance increase, especially around modded farms.").setControl(option -> new SliderControl((Option)option, 16, 192, 8, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.EXTREME).build();
        OptionImpl maxEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Vertical Entity Distance").setTooltip("Hides and does not tick entities underneath this many blocks, improving performance above caves. This should ideally be set lower than the horizontal distance.").setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceY.get()).setImpact(OptionImpact.EXTREME).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxEntityDistance).add((Option)maxEntityDistanceVertical).build());
        OptionImpl maxTileEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Max Tile Distance").setTooltip("Hides block entities beyond this many blocks. Huge performance increase, especially around lots of modded machines.").setControl(option -> new SliderControl((Option)option, 16, 256, 8, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.HIGH).build();
        OptionImpl maxTileEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName("Vertical Tile Distance").setTooltip("Hides block entities underneath this many blocks, improving performance above caves (if you have your machines in caves, for some reason). This should ideally be set lower than the horizontal distance.").setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.quantity((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.get()).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxTileEntityDistance).add((Option)maxTileEntityDistanceVertical).build());
        this.pages.add(new OptionPage("Extras", ImmutableList.copyOf(groups)));
    }
}

