/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.Zoom;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;
import vice.magnesium_extras.features.Zoom.ZoomUtils;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Unique
    private static final ResourceLocation ZOOM_OVERLAY = new ResourceLocation("magnesium_extras:textures/misc/zoom_overlay.png");
    @Final
    @Shadow
    private Minecraft field_78531_r;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void zoomTick(CallbackInfo info) {
        if (!((String)MagnesiumExtrasConfig.zoomTransition.get()).equals(MagnesiumExtrasConfig.ZoomTransitionOptions.OFF.toString())) {
            ZoomUtils.updateZoomFovMultiplier();
        }
        if (((Boolean)MagnesiumExtrasConfig.zoomOverlay.get()).booleanValue()) {
            ZoomUtils.updateZoomOverlayAlpha();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getFov"}, cancellable=true)
    private void getZoomedFov(ActiveRenderInfo camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> info) {
        double fov = (Double)info.getReturnValue();
        if (!((String)MagnesiumExtrasConfig.zoomTransition.get()).equals(MagnesiumExtrasConfig.ZoomTransitionOptions.OFF.toString())) {
            if (ZoomUtils.zoomFovMultiplier != 1.0f) {
                info.setReturnValue((Object)(fov *= (double)MathHelper.func_219799_g((float)tickDelta, (float)ZoomUtils.lastZoomFovMultiplier, (float)ZoomUtils.zoomFovMultiplier)));
            }
        } else if (ZoomUtils.zoomState) {
            double zoomedFov = fov / ZoomUtils.zoomDivisor;
            info.setReturnValue((Object)zoomedFov);
        }
        if (ZoomUtils.lastZoomState && changingFov) {
            this.field_78531_r.field_71438_f.func_174979_m();
        }
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/GameSettings;hideGui:Z")}, method={"render(FJZ)V"})
    public void injectZoomOverlay(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        if (((Boolean)MagnesiumExtrasConfig.zoomOverlay.get()).booleanValue()) {
            if (this.field_78531_r.field_71474_y.field_74319_N) {
                return;
            }
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            if (!((String)MagnesiumExtrasConfig.zoomTransition.get()).equals(MagnesiumExtrasConfig.ZoomTransitionOptions.OFF.toString())) {
                if (ZoomUtils.zoomFovMultiplier != 0.0f) {
                    float transparency = MathHelper.func_219799_g((float)tickDelta, (float)ZoomUtils.lastZoomOverlayAlpha, (float)ZoomUtils.zoomOverlayAlpha);
                    this.renderZoomOverlay(transparency);
                }
            } else if (ZoomUtils.zoomState) {
                this.renderZoomOverlay(1.0f);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        }
    }

    @Unique
    public void renderZoomOverlay(float f) {
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        this.field_78531_r.func_110434_K().func_110577_a(ZOOM_OVERLAY);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_(0.0, (double)this.field_78531_r.func_228018_at_().func_198087_p(), -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_((double)this.field_78531_r.func_228018_at_().func_198107_o(), (double)this.field_78531_r.func_228018_at_().func_198087_p(), -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_((double)this.field_78531_r.func_228018_at_().func_198107_o(), 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferBuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

