/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.performance;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderTypeLookup.class})
public class RenderTypeLookupMixin {
    @Shadow
    private static boolean field_228388_c_;
    @Shadow
    @Final
    private static Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks;
    @Shadow
    @Final
    private static Map<IRegistryDelegate<Fluid>, Predicate<RenderType>> fluidRenderChecks;

    @Inject(remap=false, at={@At(value="HEAD")}, method={"canRenderInLayer(Lnet/minecraft/block/BlockState;Lnet/minecraft/client/renderer/RenderType;)Z"}, cancellable=true)
    private static void render(BlockState state, RenderType type, CallbackInfoReturnable<Boolean> cir) {
        Block block = state.func_177230_c();
        if (block instanceof LeavesBlock) {
            cir.setReturnValue((Object)(field_228388_c_ ? type == RenderType.func_228641_d_() : type == RenderType.func_228639_c_()));
        } else {
            Predicate<RenderType> rendertype = blockRenderChecks.get(block.delegate);
            cir.setReturnValue((Object)(rendertype != null ? rendertype.test(type) : type == RenderType.func_228639_c_()));
        }
    }

    @Inject(remap=false, at={@At(value="HEAD")}, method={"canRenderInLayer(Lnet/minecraft/fluid/FluidState;Lnet/minecraft/client/renderer/RenderType;)Z"}, cancellable=true)
    private static void render(FluidState fluid, RenderType type, CallbackInfoReturnable<Boolean> cir) {
        Predicate<RenderType> rendertype = fluidRenderChecks.get(fluid.func_206886_c().delegate);
        cir.setReturnValue((Object)(rendertype != null ? rendertype.test(type) : type == RenderType.func_228639_c_()));
    }
}

