/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light;

import me.jellysquid.mods.sodium.client.render.entity.EntityLightSampler;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class EntityLighter {
    private static final double MIN_BOX_SIZE = 0.001;
    private static final double MAX_LIGHT_VAL = 15.0;
    private static final double MAX_LIGHTMAP_COORD = 240.0;

    public static <T extends Entity> int getBlendedLight(EntityLightSampler<T> lighter, T entity, float tickDelta) {
        boolean calcBlockLight = !entity.func_70027_ad();
        double x1 = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70169_q, (double)entity.func_226277_ct_());
        double y1 = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70167_r, (double)entity.func_226278_cu_());
        double z1 = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70166_s, (double)entity.func_226281_cx_());
        double width = Math.max((double)entity.func_213311_cf(), 0.001);
        double height = Math.max((double)entity.func_213302_cg(), 0.001);
        double x2 = x1 + width;
        double y2 = y1 + height;
        double z2 = z1 + width;
        int bMinX = MathHelper.func_76128_c((double)x1);
        int bMinY = MathHelper.func_76128_c((double)y1);
        int bMinZ = MathHelper.func_76128_c((double)z1);
        int bMaxX = MathHelper.func_76143_f((double)x2);
        int bMaxY = MathHelper.func_76143_f((double)y2);
        int bMaxZ = MathHelper.func_76143_f((double)z2);
        double max = 0.0;
        double sl = 0.0;
        double bl = 0.0;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int bX = bMinX; bX < bMaxX; ++bX) {
            double ix1 = Math.max((double)bX, x1);
            double ix2 = Math.min((double)(bX + 1), x2);
            for (int bY = bMinY; bY < bMaxY; ++bY) {
                double iy1 = Math.max((double)bY, y1);
                double iy2 = Math.min((double)(bY + 1), y2);
                for (int bZ = bMinZ; bZ < bMaxZ; ++bZ) {
                    pos.func_181079_c(bX, bY, bZ);
                    BlockState blockState = entity.field_70170_p.func_180495_p((BlockPos)pos);
                    if (blockState.func_200015_d((IBlockReader)entity.field_70170_p, (BlockPos)pos) && blockState.func_185906_d() <= 0) continue;
                    double iz1 = Math.max((double)bZ, z1);
                    double iz2 = Math.min((double)(bZ + 1), z2);
                    double weight = (ix2 - ix1) * (iy2 - iy1) * (iz2 - iz1);
                    max += weight;
                    sl += weight * ((double)lighter.bridge$getSkyLight(entity, (BlockPos)pos) / 15.0);
                    if (calcBlockLight) {
                        bl += weight * ((double)lighter.bridge$getBlockLight(entity, (BlockPos)pos) / 15.0);
                        continue;
                    }
                    bl += weight;
                }
            }
        }
        int bli = MathHelper.func_76128_c((double)(bl / max * 240.0));
        int sli = MathHelper.func_76128_c((double)(sl / max * 240.0));
        return (sli & 0xFFFF) << 16 | bli & 0xFFFF;
    }
}

