/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.cache;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockDisplayReader;

public class ArrayLightDataCache
extends LightDataAccess {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int BLOCK_LENGTH = 20;
    private final long[] light;
    private int xOffset;
    private int yOffset;
    private int zOffset;

    public ArrayLightDataCache(IBlockDisplayReader world) {
        this.world = world;
        this.light = new long[8000];
    }

    public void reset(SectionPos origin) {
        this.xOffset = origin.func_218161_d() - 2;
        this.yOffset = origin.func_218151_e() - 2;
        this.zOffset = origin.func_218164_f() - 2;
        Arrays.fill(this.light, 0L);
    }

    private int index(int x, int y, int z) {
        int x2 = x - this.xOffset;
        int y2 = y - this.yOffset;
        int z2 = z - this.zOffset;
        return z2 * 20 * 20 + y2 * 20 + x2;
    }

    @Override
    public long get(int x, int y, int z) {
        int l = this.index(x, y, z);
        long word = this.light[l];
        if (word != 0L) {
            return word;
        }
        this.light[l] = this.compute(x, y, z);
        return this.light[l];
    }
}

