/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.occlusion;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class BlockOcclusionCache {
    private static final byte UNCACHED_VALUE = 127;
    private final Object2ByteLinkedOpenHashMap<CachedOcclusionShapeTest> map;
    private final CachedOcclusionShapeTest cachedTest = new CachedOcclusionShapeTest();
    private final BlockPos.Mutable cpos = new BlockPos.Mutable();

    public BlockOcclusionCache() {
        this.map = new Object2ByteLinkedOpenHashMap(2048, 0.5f);
        this.map.defaultReturnValue((byte)127);
    }

    public boolean shouldDrawSide(BlockState selfState, IBlockReader view, BlockPos pos, Direction facing) {
        BlockPos.Mutable adjPos = this.cpos;
        adjPos.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        BlockState adjState = view.func_180495_p((BlockPos)adjPos);
        if (selfState.func_200017_a(adjState, facing)) {
            return false;
        }
        if (adjState.func_200132_m()) {
            VoxelShape selfShape = selfState.func_215702_a(view, pos, facing);
            VoxelShape adjShape = adjState.func_215702_a(view, (BlockPos)adjPos, facing.func_176734_d());
            if (selfShape == VoxelShapes.func_197868_b() && adjShape == VoxelShapes.func_197868_b()) {
                return false;
            }
            if (selfShape.func_197766_b()) {
                if (adjShape.func_197766_b()) {
                    return true;
                }
                if (!adjState.func_242698_a(view, (BlockPos)adjPos, facing.func_176734_d(), BlockVoxelShape.FULL)) {
                    return true;
                }
            }
            return this.calculate(selfShape, adjShape);
        }
        return true;
    }

    private boolean calculate(VoxelShape selfShape, VoxelShape adjShape) {
        CachedOcclusionShapeTest cache = this.cachedTest;
        cache.a = selfShape;
        cache.b = adjShape;
        cache.updateHash();
        byte cached = this.map.getByte((Object)cache);
        if (cached != 127) {
            return cached == 1;
        }
        boolean ret = VoxelShapes.func_197879_c((VoxelShape)selfShape, (VoxelShape)adjShape, (IBooleanFunction)IBooleanFunction.field_223234_e_);
        this.map.put((Object)cache.copy(), (byte)(ret ? 1 : 0));
        if (this.map.size() > 2048) {
            this.map.removeLastByte();
        }
        return ret;
    }

    private static final class CachedOcclusionShapeTest {
        private VoxelShape a;
        private VoxelShape b;
        private int hashCode;

        private CachedOcclusionShapeTest() {
        }

        private CachedOcclusionShapeTest(VoxelShape a, VoxelShape b, int hashCode) {
            this.a = a;
            this.b = b;
            this.hashCode = hashCode;
        }

        public void updateHash() {
            int result = System.identityHashCode(this.a);
            this.hashCode = result = 31 * result + System.identityHashCode(this.b);
        }

        public CachedOcclusionShapeTest copy() {
            return new CachedOcclusionShapeTest(this.a, this.b, this.hashCode);
        }

        public boolean equals(Object o) {
            if (o instanceof CachedOcclusionShapeTest) {
                CachedOcclusionShapeTest that = (CachedOcclusionShapeTest)o;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

