/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;

public class ClonedChunkSectionCache {
    private final World world;
    private final ConcurrentLinkedQueue<ClonedChunkSection> inactivePool = new ConcurrentLinkedQueue();
    private final Long2ReferenceMap<ClonedChunkSection> byPosition = new Long2ReferenceOpenHashMap();

    public ClonedChunkSectionCache(World world) {
        this.world = world;
    }

    public synchronized ClonedChunkSection acquire(int x, int y, int z) {
        long key = SectionPos.func_218166_b((int)x, (int)y, (int)z);
        ClonedChunkSection section = (ClonedChunkSection)this.byPosition.get(key);
        if (section != null) {
            this.inactivePool.remove(section);
        } else {
            section = this.createSection(x, y, z);
        }
        section.acquireReference();
        return section;
    }

    private ClonedChunkSection createSection(int x, int y, int z) {
        ClonedChunkSection section;
        if (!this.inactivePool.isEmpty()) {
            section = (ClonedChunkSection)this.inactivePool.remove();
            this.byPosition.remove(section.getPosition().func_218146_v());
        } else {
            section = this.allocate();
        }
        SectionPos pos = SectionPos.func_218154_a((int)x, (int)y, (int)z);
        section.init(pos);
        this.byPosition.put(pos.func_218146_v(), (Object)section);
        return section;
    }

    public synchronized void invalidate(int x, int y, int z) {
        this.byPosition.remove(SectionPos.func_218166_b((int)x, (int)y, (int)z));
    }

    public void release(ClonedChunkSection section) {
        if (section.releaseReference()) {
            this.tryReclaim(section);
        }
    }

    private ClonedChunkSection allocate() {
        return new ClonedChunkSection(this, this.world);
    }

    private void tryReclaim(ClonedChunkSection section) {
        this.inactivePool.add(section);
    }
}

