/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.world_ticking;

import java.util.Random;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld
extends World {
    @Shadow
    protected abstract void func_211530_a(BlockPos var1, BlockState var2, IParticleData var3, boolean var4);

    protected MixinClientWorld(ISpawnWorldInfo mutableWorldProperties, RegistryKey<World> registryKey, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean bl, boolean bl2, long l) {
        super(mutableWorldProperties, registryKey, dimensionType, profiler, bl, bl2, l);
    }

    @Redirect(method={"doRandomBlockDisplayTicks"}, at=@At(value="NEW", target="java/util/Random"))
    private Random redirectRandomTickRandom() {
        return new XoRoShiRoRandom();
    }

    @Overwrite
    public void func_184153_a(int xCenter, int yCenter, int zCenter, int radius, Random random, boolean spawnBarrierParticles, BlockPos.Mutable pos) {
        FluidState fluidState;
        int x = xCenter + (random.nextInt(radius) - random.nextInt(radius));
        int y = yCenter + (random.nextInt(radius) - random.nextInt(radius));
        int z = zCenter + (random.nextInt(radius) - random.nextInt(radius));
        pos.func_181079_c(x, y, z);
        BlockState blockState = this.func_180495_p((BlockPos)pos);
        if (!blockState.func_196958_f()) {
            this.performBlockDisplayTick(blockState, (BlockPos)pos, random, spawnBarrierParticles);
        }
        if (!blockState.func_235785_r_((IBlockReader)this, (BlockPos)pos)) {
            this.performBiomeParticleDisplayTick((BlockPos)pos, random);
        }
        if (!(fluidState = blockState.func_204520_s()).func_206888_e()) {
            this.performFluidDisplayTick(blockState, fluidState, (BlockPos)pos, random);
        }
    }

    private void performBlockDisplayTick(BlockState blockState, BlockPos pos, Random random, boolean spawnBarrierParticles) {
        blockState.func_177230_c().func_180655_c(blockState, (World)this, pos, random);
        if (spawnBarrierParticles && blockState.func_203425_a(Blocks.field_180401_cv)) {
            this.performBarrierDisplayTick(pos);
        }
    }

    private void performBarrierDisplayTick(BlockPos pos) {
        this.func_195594_a((IParticleData)ParticleTypes.field_197610_c, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
    }

    private void performBiomeParticleDisplayTick(BlockPos pos, Random random) {
        ParticleEffectAmbience config = this.func_226691_t_(pos).func_235090_t_().orElse(null);
        if (config != null && config.func_235047_a_(random)) {
            this.func_195594_a(config.func_235044_a_(), (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void performFluidDisplayTick(BlockState blockState, FluidState fluidState, BlockPos pos, Random random) {
        fluidState.func_206881_a((World)this, pos, random);
        IParticleData particleEffect = fluidState.func_204521_c();
        if (particleEffect != null && random.nextInt(10) == 0) {
            boolean solid = blockState.func_224755_d((IBlockReader)this, pos, Direction.DOWN);
            BlockPos blockPos = pos.func_177977_b();
            this.func_211530_a(blockPos, this.func_180495_p(blockPos), particleEffect, solid);
        }
    }
}

