/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib;

import de.erdbeerbaerlp.guilib.components.Button;
import de.erdbeerbaerlp.guilib.components.CheckBox;
import de.erdbeerbaerlp.guilib.components.EnumSlider;
import de.erdbeerbaerlp.guilib.components.Image;
import de.erdbeerbaerlp.guilib.components.Label;
import de.erdbeerbaerlp.guilib.components.ProgressBar;
import de.erdbeerbaerlp.guilib.components.ScrollPanel;
import de.erdbeerbaerlp.guilib.components.Slider;
import de.erdbeerbaerlp.guilib.components.Spinner;
import de.erdbeerbaerlp.guilib.components.TextField;
import de.erdbeerbaerlp.guilib.components.ToggleButton;
import de.erdbeerbaerlp.guilib.gui.ExtendedScreen;
import java.util.Random;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.BossInfo;

public class ExampleGUI
extends ExtendedScreen {
    private Button exampleButton;
    private TextField exampleTextField;
    private Label exampleLabel1;
    private Button exitButton;
    private CheckBox exampleCheckbox;
    private Slider exampleSlider1;
    private EnumSlider exampleSlider2;
    private ToggleButton exampleToggleButton;
    private EnumSlider drawTypeSlider;
    private Image beeGif;
    private Image apple;
    private Image dynamicImage;
    private TextField urlField;
    private Button nextPageButton;
    private Button prevPageButton;
    private Label pageIndicator;
    private ScrollPanel scrollPanel;
    private Button scrollButton1;
    private Button scrollButton2;
    private TextField scrollTextField;
    private Slider xSlider;
    private Slider ySlider;
    private Slider contentSlider;
    private Image pikachu;
    private Slider scrollSlider;
    private Spinner spinner;
    private ProgressBar pBar;
    private Slider pBarSlider;
    private EnumSlider pBarColorSlider;
    private Button pBarLoader;
    private ToggleButton spinnerPlayPause;
    private Thread loader;

    public ExampleGUI(Screen parent) {
        super(parent);
    }

    @Override
    public void buildGui() {
        this.exampleButton = new Button(50, 50, "Button", Button.DefaultButtonIcons.SAVE);
        this.exampleTextField = new TextField(50, 100, 150);
        this.exampleLabel1 = new Label("Example GUI", this.field_230708_k_ / 2, 10);
        this.exitButton = new Button(0, 0, Button.DefaultButtonIcons.DELETE);
        this.exampleCheckbox = new CheckBox(50, 70, "Checkbox", false);
        this.exampleSlider1 = new Slider(50, 130, "Slider: ", 0.0, 100.0, 50.0, () -> System.out.println(this.exampleSlider1.getValue()));
        this.exampleSlider2 = new EnumSlider(200, 130, "Enum Slider: ", ExampleEnum.class, ExampleEnum.EXAMPLE, () -> {
            System.out.println("Enum changed to \"" + ((ExampleEnum)this.exampleSlider2.getEnum()).getName() + "\"");
            System.out.println("Index: " + this.exampleSlider2.getValueInt());
            System.out.println("Other Value: " + ((ExampleEnum)this.exampleSlider2.getEnum()).getOtherValue());
        });
        this.exampleToggleButton = new ToggleButton(50, 170, "Toggle Button: ");
        this.drawTypeSlider = new EnumSlider(156, 170, "Draw type: ", ToggleButton.DrawType.class, ToggleButton.DrawType.COLORED_LINE, () -> this.exampleToggleButton.setDrawType((ToggleButton.DrawType)this.drawTypeSlider.getEnum()));
        this.beeGif = new Image(250, 40, 64, 64);
        this.apple = new Image(0, 0);
        this.dynamicImage = new Image(0, 0, 300, 180);
        this.urlField = new TextField(0, 0, 240);
        this.nextPageButton = new Button(0, 0, 40, ">");
        this.prevPageButton = new Button(0, 0, 40, "<");
        this.pageIndicator = new Label(0, 0);
        this.scrollPanel = new ScrollPanel(0, 0, 300, 200);
        this.scrollButton1 = new Button(30, 10, "Button 1");
        this.scrollButton2 = new Button(30, 330, "Button 2");
        this.scrollTextField = new TextField(2, 300, 100);
        this.scrollSlider = new Slider(10, 212, "Another Slider: ", -20.0, 20.0, 0.0, () -> System.out.println("Changed to " + this.scrollSlider.getValueInt()));
        this.xSlider = new Slider(10, 20, "ScrollPanel X Pos", 0.0, 350.0, 0.0, () -> this.scrollPanel.setX(this.xSlider.getValueInt()));
        this.ySlider = new Slider(10, 50, "ScrollPanel Y Pos", 0.0, 255.0, 0.0, () -> this.scrollPanel.setY(this.ySlider.getValueInt()));
        this.contentSlider = new Slider(10, 80, "ScrollPanel Content length", 0.0, 1200.0, 500.0, () -> this.scrollPanel.setContentHeight(this.contentSlider.getValueInt()));
        this.pikachu = new Image(150, 40, 120, 70);
        this.spinner = new Spinner(0, 0);
        this.pBar = new ProgressBar(0, 0, 200);
        this.pBarSlider = new Slider(0, 0, "ProgressBar value: ", 0.0, 100.0, 0.0, () -> this.pBar.setValue(this.pBarSlider.getValueInt()));
        this.pBarColorSlider = new EnumSlider(0, 0, "Progress Bar Color: ", BossInfo.Color.class, BossInfo.Color.BLUE, () -> this.pBar.setColor((BossInfo.Color)this.pBarColorSlider.getEnum()));
        this.pBarLoader = new Button(0, 0, "Load Something", Button.DefaultButtonIcons.PLAY);
        this.spinnerPlayPause = new ToggleButton(0, 0, Button.DefaultButtonIcons.PAUSE, Button.DefaultButtonIcons.PLAY);
        this.beeGif.loadImage("https://gamepedia.cursecdn.com/minecraft_gamepedia/thumb/5/58/Bee.gif/120px-Bee.gif");
        this.apple.loadImage(new ResourceLocation("minecraft", "textures/item/apple.png"));
        this.dynamicImage.loadImage("https://www.minecraft.net/etc.clientlibs/minecraft/clientlibs/main/resources/img/header/logo.png");
        this.pikachu.loadImage("https://i.pinimg.com/originals/9f/b1/25/9fb125f1fedc8cc62ab5b20699ebd87d.gif");
        this.exampleButton.setClickListener(() -> System.out.println("I have been clicked!"));
        this.exampleCheckbox.setChangeListener(() -> System.out.println(this.exampleCheckbox.isChecked() ? "I just got Checked" : "I just have been unchecked :/"));
        this.exitButton.setClickListener(this::close);
        this.exampleTextField.setReturnAction(() -> this.exampleButton.setText(this.exampleTextField.getText()));
        this.exampleToggleButton.setClickListener(() -> {
            System.out.println("New Value: " + this.exampleToggleButton.getValue());
            this.exampleButton.setEnabled(this.exampleToggleButton.getValue());
        });
        this.apple.setCallback(() -> {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187739_dZ, (float)1.0f));
            this.apple.setVisible(false);
            this.apple.disable();
        });
        this.urlField.setText(this.dynamicImage.getImageURL());
        this.urlField.setReturnAction(() -> this.dynamicImage.loadImage(this.urlField.getText()));
        this.nextPageButton.setClickListener(this::nextPage);
        this.prevPageButton.setClickListener(this::prevPage);
        this.pBarLoader.setClickListener(() -> {
            if (this.loader == null || !this.loader.isAlive()) {
                this.loader = new Thread(() -> {
                    this.pBarSlider.disable();
                    this.pBar.setValue(0);
                    this.pBar.setMaxValue(140);
                    this.pBarSlider.setValue(0.0);
                    this.pBarSlider.setMaxValue(140.0);
                    for (int i = 0; i < 140; ++i) {
                        this.pBar.increment(1);
                        this.pBarSlider.setValue(this.pBar.getValue());
                        try {
                            Thread.sleep(new Random().nextInt(5) * 100);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.pBar.setValue(0);
                    this.pBar.setMaxValue(100);
                    this.pBarSlider.setValue(0.0);
                    this.pBarSlider.setMaxValue(100.0);
                    this.pBarSlider.enable();
                });
                this.loader.start();
            }
        });
        this.exampleButton.setTooltips("Example Tooltip", "This is a Button");
        this.exampleCheckbox.setTooltips("Another Tooltip", "This is a Checkbox", "");
        this.exampleTextField.setTooltips("A simple Textbox", "This one does support colors too!", "Simply use a \u00a7", "Press return to run a callback");
        this.exitButton.setTooltips("Closes this GUI");
        this.exampleSlider1.setTooltips("A simple double/integer slider");
        this.exampleSlider2.setTooltips("This slider works using Enums", "It will change through all enum values");
        this.exampleToggleButton.setTooltips("This button can be toggled");
        this.drawTypeSlider.setTooltips("Change how the toggle button will be rendered");
        this.beeGif.setTooltips("This is an example image", "It was loaded from an URL");
        this.apple.setTooltips("Oh, look at this apple!", "", "Click to eat");
        this.scrollButton1.setTooltips("An button in an scroll panel");
        this.pikachu.setTooltips("Click me to open an URL");
        this.scrollButton1.setClickListener(() -> System.out.println("TEST1"));
        this.scrollButton2.setClickListener(() -> System.out.println("TEST2"));
        this.scrollTextField.setReturnAction(() -> System.out.println(this.scrollTextField.getText()));
        this.pikachu.setCallback(() -> this.openURL("http://pikachu.com", opened -> {
            if (!opened) {
                this.pikachu.hide();
            }
        }));
        this.spinnerPlayPause.setClickListener(() -> {
            if (this.spinnerPlayPause.getValue()) {
                this.spinner.resume();
            } else {
                this.spinner.stop();
            }
        });
        this.exampleTextField.setAcceptsColors(true);
        this.exampleTextField.setText("Text Field");
        this.exampleTextField.setLabel("Text Field Label");
        this.scrollTextField.setLabel("Example Text field in scroll panel");
        this.scrollTextField.setText("TEEXT");
        this.exampleLabel1.setCentered();
        this.pageIndicator.setCentered();
        this.exampleToggleButton.setValue(true);
        this.urlField.setLabel("Image URL");
        this.urlField.setMaxStringLength(1024);
        this.pBar.setText("Progress Bar:");
        this.pBarSlider.setShowDecimal(false);
        this.spinnerPlayPause.setValue(true);
        this.spinnerPlayPause.setDrawType(ToggleButton.DrawType.STRING_OR_ICON);
        this.addAllComponents(this.exampleLabel1, this.exitButton, this.prevPageButton, this.nextPageButton, this.pageIndicator);
        this.addComponent(this.exampleButton, 0);
        this.addComponent(this.exampleCheckbox, 0);
        this.addComponent(this.exampleTextField, 0);
        this.addComponent(this.exampleSlider1, 0);
        this.addComponent(this.exampleSlider2, 0);
        this.addComponent(this.exampleToggleButton, 0);
        this.addComponent(this.drawTypeSlider, 0);
        this.addComponent(this.beeGif, 0);
        this.addComponent(this.apple, 0);
        this.addComponent(this.dynamicImage, 1);
        this.addComponent(this.urlField, 1);
        this.addComponent(this.scrollPanel, 2);
        this.addComponent(this.xSlider, 3);
        this.addComponent(this.ySlider, 3);
        this.addComponent(this.contentSlider, 3);
        this.addComponent(this.spinner, 4);
        this.addComponent(this.spinnerPlayPause, 4);
        this.addComponent(this.pBar, 4);
        this.addComponent(this.pBarSlider, 4);
        this.addComponent(this.pBarColorSlider, 4);
        this.addComponent(this.pBarLoader, 4);
        this.scrollPanel.addAllComponents(this.scrollButton1, this.scrollButton2, this.scrollTextField, this.pikachu, this.scrollSlider);
        this.scrollPanel.fitContent();
    }

    @Override
    public void updateGui() {
        this.exampleLabel1.setX(this.field_230708_k_ / 2);
        this.nextPageButton.setPosition(this.field_230708_k_ - this.nextPageButton.func_230998_h_() - 6, this.field_230709_l_ - this.nextPageButton.getHeight() - 15);
        this.prevPageButton.setPosition(6, this.nextPageButton.getY());
        this.pageIndicator.setPosition(this.field_230708_k_ / 2, this.field_230709_l_ - 13);
        this.pageIndicator.setText("Page " + this.getCurrentPage());
        this.exitButton.setX(this.field_230708_k_ - this.exitButton.func_230998_h_() - 6);
        this.exitButton.setY(6);
        this.apple.setPosition(this.exitButton.getX() - 40, this.exitButton.getY() + 30);
        this.dynamicImage.setPosition(this.field_230708_k_ / 2 - 150, 50);
        this.urlField.setPosition(this.dynamicImage.getX(), this.dynamicImage.getY() - 30);
        this.urlField.func_230991_b_(this.dynamicImage.func_230998_h_());
        this.spinner.setPosition(this.field_230708_k_ / 2 - 16, this.pBar.getY() - 50);
        this.spinnerPlayPause.setPosition(this.spinner.getX() + 32 + 20, this.spinner.getY() + 8);
        this.pBar.setPosition(this.spinner.getX() - this.pBar.func_230998_h_() / 2, this.field_230709_l_ / 2);
        this.pBarSlider.setPosition(this.pBar.getX() + 25, this.pBar.getY() + 40);
        this.pBarColorSlider.setPosition(this.pBarSlider.getX(), this.pBarSlider.getY() + this.pBarSlider.getHeight() + 4);
        this.pBarLoader.setPosition(this.pBarSlider.getX() - this.pBarLoader.func_230998_h_() - 12, this.pBarSlider.getY() + this.pBarSlider.getHeight() + 4);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public boolean doesEscCloseGui() {
        return true;
    }

    public static enum ExampleEnum {
        THIS("This", 1.0f),
        IS("is", 100.45f),
        AN("an", -90.0f),
        EXAMPLE("example", 1337.0f),
        SLIDER("slider", -2387.0f),
        WITH("with", 1.0E-9f),
        ENUM("enum", (float)Math.PI),
        VALUES("values.", 98234.5f),
        YAAAY("Yaay!", -0.0f);

        private final String name;
        private final float otherValue;

        private ExampleEnum(String name, float someOtherValue) {
            this.name = name;
            this.otherValue = someOtherValue;
        }

        public String getName() {
            return this.name;
        }

        public float getOtherValue() {
            return this.otherValue;
        }
    }
}

