/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import de.erdbeerbaerlp.guilib.util.ImageUtil;
import java.io.IOException;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class Button
extends GuiComponent {
    protected DynamicTexture BUTTON_ICON_IMAGE;
    protected ResourceLocation BUTTON_ICON;
    protected String displayString;
    private Runnable callback;
    private String errorTooltip = "";

    public Button(int xPos, int yPos, String displayString) {
        this(xPos, yPos, 100, displayString);
    }

    public Button(int xPos, int yPos, int width, String displayString) {
        this(xPos, yPos, width, 20, displayString);
    }

    public Button(int xPos, int yPos, int width, String displayString, ResourceLocation icon) {
        this(xPos, yPos, width, 20, displayString, icon);
    }

    public Button(int xPos, int yPos, int width, int height, String displayString) {
        this(xPos, yPos, width, height, displayString, (ResourceLocation)null);
    }

    public Button(int xPos, int yPos, int width, int height, String displayString, ResourceLocation icon) {
        super(xPos, yPos, width, height);
        this.BUTTON_ICON = icon;
        this.displayString = displayString;
    }

    public Button(int xPos, int yPos, int width, int height, String displayString, String iconURL) {
        this(xPos, yPos, width, height, displayString);
        try {
            this.BUTTON_ICON_IMAGE = new DynamicTexture(ImageUtil.getImageFromIS(ImageUtil.getInputStreamFromImageURL(iconURL), false, 16, 16, true));
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause().getLocalizedMessage();
        }
        this.displayString = displayString;
    }

    public Button(int xPos, int yPos, int width, int height, String displayString, URL iconURL) {
        this(xPos, yPos, width, height, displayString, iconURL.toString());
    }

    public Button(int xPos, int yPos, int width, int height, String displayString, NativeImage icon) {
        super(xPos, yPos, width, height);
        this.BUTTON_ICON_IMAGE = new DynamicTexture(icon);
        this.displayString = displayString;
    }

    public Button(int xPos, int yPos, String displayString, ResourceLocation icon) {
        this(xPos, yPos, 100, displayString, icon);
    }

    public Button(int xPos, int yPos, ResourceLocation icon) {
        this(xPos, yPos, 20, "", icon);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        int color = 0xE0E0E0;
        boolean bl = this.field_230692_n_ = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.field_230688_j_ && mouseY < this.getY() + this.field_230689_k_;
        if (this.packedFGColor != 0) {
            color = this.packedFGColor;
        } else if (!this.isEnabled()) {
            color = 0xA0A0A0;
        } else if (this.hovered) {
            color = 0xFFFFA0;
        }
        this.mc.func_110434_K().func_110577_a(field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        int i = this.func_230989_a_(this.func_230449_g_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_238474_b_(matrixStack, this.getX(), this.getY(), 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_238474_b_(matrixStack, this.getX() + this.field_230688_j_ / 2, this.getY(), 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_230441_a_(matrixStack, this.mc, mouseX, mouseY);
        int j = this.getFGColor();
        int bx = this.getX();
        int mwidth = this.field_230688_j_;
        if (this.BUTTON_ICON != null && this.BUTTON_ICON_IMAGE == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BUTTON_ICON);
            Button.func_238463_a_((MatrixStack)matrixStack, (int)(bx + 2), (int)(this.getY() + 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            bx += 18;
            mwidth -= 16;
        } else if (this.BUTTON_ICON_IMAGE != null && this.BUTTON_ICON == null) {
            this.mc.func_110434_K().func_110577_a(this.mc.func_110434_K().func_110578_a("icon", this.BUTTON_ICON_IMAGE));
            Button.func_238463_a_((MatrixStack)matrixStack, (int)(bx + 2), (int)this.getY(), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            bx += 18;
            mwidth -= 16;
        } else if (this.BUTTON_ICON_IMAGE == null && this.BUTTON_ICON == null && !this.errorTooltip.equals("")) {
            this.mc.func_110434_K().func_110577_a(errorIcon);
            Button.func_238463_a_((MatrixStack)matrixStack, (int)(bx + 2), (int)this.getY(), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            bx += 18;
            mwidth -= 16;
        }
        String buttonText = this.displayString;
        int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
        if (strWidth > mwidth - 6 && strWidth > ellipsisWidth) {
            buttonText = this.mc.field_71466_p.func_238412_a_(buttonText, mwidth - 6 - ellipsisWidth).trim() + "...";
        }
        Button.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)buttonText, (int)(bx + mwidth / 2), (int)(this.getY() + (this.field_230689_k_ - 8) / 2), (int)color);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        this.playPressSound();
        if (this.enabled) {
            this.onClick();
        }
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }

    public final void setText(String text) {
        this.displayString = text;
    }

    public final void setClickListener(Runnable r) {
        this.callback = r;
    }

    public void onClick() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public String[] getTooltips() {
        if (this.BUTTON_ICON == null && this.BUTTON_ICON_IMAGE == null && !this.errorTooltip.isEmpty()) {
            return (String[])ArrayUtils.addAll((Object[])super.getTooltips(), (Object[])new String[]{"", "\u00a7cError loading image:", "\u00a7c" + this.errorTooltip});
        }
        return super.getTooltips();
    }

    public static class DefaultButtonIcons {
        public static final ResourceLocation ADD = new ResourceLocation("eguilib:textures/gui/buttonicons/add.png");
        public static final ResourceLocation DELETE = new ResourceLocation("eguilib:textures/gui/buttonicons/delete.png");
        public static final ResourceLocation PLAY = new ResourceLocation("eguilib:textures/gui/buttonicons/play.png");
        public static final ResourceLocation PAUSE = new ResourceLocation("eguilib:textures/gui/buttonicons/pause.png");
        public static final ResourceLocation STOP = new ResourceLocation("eguilib:textures/gui/buttonicons/stop.png");
        public static final ResourceLocation SAVE = new ResourceLocation("eguilib:textures/gui/buttonicons/save.png");
        public static final ResourceLocation NEW = new ResourceLocation("eguilib:textures/gui/buttonicons/new.png");
        public static final ResourceLocation FILE = new ResourceLocation("eguilib:textures/gui/buttonicons/file.png");
        public static final ResourceLocation FILE_TXT = new ResourceLocation("eguilib:textures/gui/buttonicons/file_txt.png");
        public static final ResourceLocation FILE_NBT = new ResourceLocation("eguilib:textures/gui/buttonicons/file_nbt.png");
        public static final ResourceLocation FILE_BIN = new ResourceLocation("eguilib:textures/gui/buttonicons/file_bin.png");
        public static final ResourceLocation ARROW_RIGHT = new ResourceLocation("eguilib:textures/gui/buttonicons/arrow-right.png");
        public static final ResourceLocation ARROW_LEFT = new ResourceLocation("eguilib:textures/gui/buttonicons/arrow-left.png");
    }
}

