/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CheckBox
extends GuiComponent {
    private static final ResourceLocation CHECKBOX_LOCATION = new ResourceLocation("minecraft", "textures/gui/checkbox.png");
    private final int boxWidth;
    private final String displayString;
    private Runnable callback;
    private boolean isChecked;

    public CheckBox(int xPos, int yPos, String displayString, boolean isChecked) {
        super(xPos, yPos, 0, 0);
        this.displayString = displayString;
        this.isChecked = isChecked;
        this.boxWidth = 11;
        this.field_230689_k_ = 11;
        this.field_230688_j_ = this.boxWidth + 2 + Minecraft.func_71410_x().field_71466_p.func_78256_a(displayString);
    }

    public CheckBox(int xPos, int yPos, String displayString) {
        this(xPos, yPos, displayString, false);
    }

    public CheckBox(int xPos, int yPos) {
        this(xPos, yPos, "", false);
    }

    public CheckBox(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, "", false);
        this.field_230688_j_ = width;
        this.field_230689_k_ = height;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void onChange() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public final void setChangeListener(Runnable r) {
        this.callback = r;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        this.field_230692_n_ = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.field_230688_j_ && mouseY < this.getY() + this.field_230689_k_;
        int color = 0xE0E0E0;
        if (this.packedFGColor != 0) {
            color = this.packedFGColor;
        } else if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.hovered) {
            color = 0xFFFFA0;
        }
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_230687_i_, (int)this.getX(), (int)this.getY(), (int)0, (int)46, (int)this.boxWidth, (int)this.field_230689_k_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.func_230927_p_());
        if (this.isChecked) {
            CheckBox.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)"x", (int)(this.getX() + this.boxWidth / 2 + 1), (int)(this.getY() + 1), (int)0xE0E0E0);
        }
        CheckBox.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)this.displayString, (int)(this.getX() + this.boxWidth + 2), (int)(this.getY() + 2), (int)color);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        this.playPressSound();
        if (this.isEnabled()) {
            this.setIsChecked(!this.isChecked());
            this.onChange();
        }
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }
}

