/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.erdbeerbaerlp.guilib.components.Slider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EnumSlider
extends Slider {
    private final Runnable action;
    private final Enum<?>[] enumValues;
    private Enum<?> enumValue;
    private int prevIndex;

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, String prefix, Class<T> enumClass, T currentVal, Runnable changeAction) {
        this(xPos, yPos, 150, 20, prefix, "", enumClass, currentVal, true, changeAction);
    }

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, int width, int height, String prefix, String suf, Class<T> enumClass, T currentVal, boolean drawStr) {
        this(xPos, yPos, width, height, prefix, suf, enumClass, currentVal, drawStr, null);
    }

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, int width, int height, String prefix, String suf, Class<T> enumClass, T currentVal, boolean drawStr, Runnable changeAction) {
        super(xPos, yPos, width, height, prefix, suf, -1.0, -1.0, -1.0, false, drawStr, null);
        this.action = changeAction;
        this.enumValue = currentVal;
        this.enumValues = (Enum[])enumClass.getEnumConstants();
        this.maxValue = this.enumValues.length;
        this.showDecimal = false;
        this.minValue = 0.0;
        this.sliderValue = ((double)this.getCurrentIndex() - this.minValue) / (this.maxValue - this.minValue);
        this.prevIndex = this.getCurrentIndex();
        String val = "";
        for (Method m : this.enumValue.getClass().getMethods()) {
            if (!m.getName().equals("getName") || m.getParameterTypes().length != 0 || m.getReturnType() != String.class) continue;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                val = (String)m.invoke(this.enumValue, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.displayString = this.dispString + (val.isEmpty() ? this.enumValue.name() : val) + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.displayString = "";
        }
    }

    public Enum<?> getEnum() {
        return this.enumValue;
    }

    public void setEnum(Enum<?> value) {
        this.enumValue = value;
        this.sliderValue = ((double)this.getCurrentIndex() - this.minValue) / (this.maxValue - this.minValue);
        this.prevIndex = this.getCurrentIndex();
    }

    @Override
    public void updateSlider() {
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        String val = this.enumValue.name();
        for (Method m : this.enumValue.getClass().getMethods()) {
            if (!m.getName().equals("getName") || m.getParameterTypes().length != 0 || m.getReturnType() != String.class) continue;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                val = (String)m.invoke(this.enumValue, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.drawString) {
            this.displayString = this.dispString + val + this.suffix;
        }
        if (this.prevIndex != this.getCurrentIndex()) {
            this.onValueChanged();
        }
        this.prevIndex = this.getCurrentIndex();
    }

    @Override
    public void onValueChanged() {
        if (this.action != null) {
            this.action.run();
        }
    }

    private int getCurrentIndex() {
        int out = 0;
        for (Enum<?> e : this.enumValues) {
            if (e.name().equals(this.enumValue.name())) {
                return out;
            }
            ++out;
        }
        return -1;
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        this.playPressSound();
        if (this.isEnabled()) {
            this.updateSlider();
            this.dragging = true;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.dragging) {
            int index = this.getCurrentIndex();
            this.sliderValue = (float)(mouseX - (this.getX() + 4)) / (float)(this.field_230688_j_ - 8);
            int sliderValue = (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (sliderValue < 0) {
                sliderValue = 0;
            }
            if (index == -1) {
                this.enumValue = this.enumValues[0];
            } else if (sliderValue < this.enumValues.length) {
                this.enumValue = this.enumValues[sliderValue];
            }
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partial);
    }
}

