/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import de.erdbeerbaerlp.guilib.util.ImageUtil;
import guilibshadow.cafe4j.image.gif.GIFFrame;
import guilibshadow.cafe4j.image.reader.GIFReader;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;

public class GifThread
extends Thread {
    private final ArrayList<Map.Entry<byte[], Integer>> gifData = new ArrayList();
    private final DynamicTexture outputTexture;
    private final boolean doGifLoop;
    private boolean paused = false;

    public GifThread(ByteArrayInputStream is, DynamicTexture outputTexture, boolean resizingImage) {
        this(is, outputTexture, true, true, resizingImage);
    }

    public GifThread(ByteArrayInputStream is, DynamicTexture outputTexture, boolean keepAspectRatio, boolean doGifLoop, boolean resizingImage) {
        this.outputTexture = outputTexture;
        this.doGifLoop = doGifLoop;
        this.setDaemon(true);
        this.setName("Gif Renderer " + UUID.randomUUID().toString());
        GIFReader r = new GIFReader();
        try {
            is.reset();
            r.read(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<GIFFrame> gifFrames = r.getGIFFrames();
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (GIFFrame frame : gifFrames) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (frame.getFrame().getWidth() <= outputTexture.func_195414_e().func_195702_a() && frame.getFrame().getHeight() <= outputTexture.func_195414_e().func_195714_b() && !resizingImage) {
                    ImageIO.write((RenderedImage)frame.getFrame(), "png", os);
                } else if (keepAspectRatio) {
                    ImageIO.write((RenderedImage)ImageUtil.scaleImageKeepAspectRatio(frame.getFrame(), outputTexture.func_195414_e().func_195702_a(), outputTexture.func_195414_e().func_195714_b()), "png", os);
                } else {
                    ImageIO.write((RenderedImage)ImageUtil.scaleImage(frame.getFrame(), outputTexture.func_195414_e().func_195702_a(), outputTexture.func_195414_e().func_195714_b()), "png", os);
                }
                this.gifData.add(new AbstractMap.SimpleEntry<byte[], Integer>(os.toByteArray(), frame.getDelay()));
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void play() {
        this.paused = false;
    }

    @Override
    public void run() {
        do {
            ArrayList<AbstractMap.SimpleEntry<NativeImage, Integer>> gifBuffer = new ArrayList<AbstractMap.SimpleEntry<NativeImage, Integer>>();
            for (Map.Entry<byte[], Integer> entry : this.gifData) {
                try {
                    ByteArrayInputStream is2 = new ByteArrayInputStream(entry.getKey());
                    NativeImage img = NativeImage.func_195713_a((InputStream)is2);
                    gifBuffer.add(new AbstractMap.SimpleEntry<NativeImage, Integer>(img, entry.getValue()));
                    is2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Map.Entry<Object, Integer> entry : gifBuffer) {
                try {
                    Minecraft.func_71410_x().execute(() -> {
                        try {
                            this.outputTexture.func_195415_a((NativeImage)frame.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.outputTexture.func_110564_a();
                    });
                    GifThread.sleep(entry.getValue() * 10);
                    while (this.paused) {
                        GifThread.sleep(1L);
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        } while (this.doGifLoop);
    }

    public boolean isPaused() {
        return this.paused;
    }
}

