/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.erdbeerbaerlp.guilib.components.GifThread;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import de.erdbeerbaerlp.guilib.util.ImageUtil;
import guilibshadow.cafe4j.image.ImageIO;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Image
extends GuiComponent {
    private final DynamicTexture loadingTexture = new DynamicTexture(32, 32, true);
    private final UUID imageUUID = UUID.randomUUID();
    private DynamicTexture image;
    private GifThread gif;
    private ResourceLocation resLoc;
    private Runnable callback;
    private String errorTooltip = "";
    private boolean imgLoaded = true;
    private GifThread loadingGif;
    private String imageURL = null;
    private boolean keepAspectRatio = true;
    private boolean acceptsNewImage = true;
    private boolean doGifLoop = true;
    private boolean shouldKeepSize = true;
    private boolean resizingImage = true;

    public Image(int x, int y, int width, int height, boolean doGifLoop) {
        this(x, y, width, height);
        this.doGifLoop = doGifLoop;
    }

    public Image(int x, int y, boolean doGifLoop) {
        this(x, y);
        this.doGifLoop = doGifLoop;
    }

    public Image(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public Image(int x, int y) {
        super(x, y, 0, 0);
        this.shouldKeepSize = false;
    }

    public void setKeepAspectRatio(boolean keepAspectRatio) {
        this.keepAspectRatio = keepAspectRatio;
        this.reloadImage();
    }

    private void reloadImage() {
        if (this.imageURL != null) {
            this.loadImage(this.imageURL);
        }
    }

    public void setShouldKeepSize(boolean shouldKeepSize) {
        this.shouldKeepSize = shouldKeepSize;
    }

    @Override
    public String[] getTooltips() {
        if (!this.errorTooltip.isEmpty()) {
            return (String[])ArrayUtils.addAll((Object[])super.getTooltips(), (Object[])new String[]{"", TextFormatting.RED + "Error loading image:", TextFormatting.RED + this.errorTooltip});
        }
        return super.getTooltips();
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setGifNotLooping() {
        this.doGifLoop = false;
    }

    public void setGifLooping() {
        this.doGifLoop = true;
    }

    public void loadImage(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            this.loadImage(is);
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
            this.image = null;
            this.resLoc = null;
            this.acceptsNewImage = true;
        }
    }

    public void loadImage(ResourceLocation res) {
        if (!this.acceptsNewImage) {
            return;
        }
        try {
            this.loadImage(this.mc.func_195551_G().func_199002_a(res).func_199027_b());
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
            this.image = null;
            this.resLoc = null;
            this.acceptsNewImage = true;
        }
    }

    public void loadImage(String url) {
        if (!this.acceptsNewImage) {
            return;
        }
        this.imageURL = url;
        this.imgLoaded = false;
        this.errorTooltip = "";
        this.acceptsNewImage = false;
        System.out.println("Starting to load " + url);
        Thread t = new Thread(() -> {
            try {
                ByteArrayInputStream is = ImageUtil.getInputStreamFromImageURL(url);
                this.acceptsNewImage = true;
                this.loadImage(is);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
                this.image = null;
                this.resLoc = null;
                this.acceptsNewImage = true;
            }
        });
        t.setDaemon(true);
        t.setName("Image download " + this.imageUUID.toString());
        t.start();
    }

    public boolean isResizingImage() {
        return this.resizingImage;
    }

    public void setResizingImage(boolean resizingImage) {
        this.resizingImage = resizingImage;
    }

    public void loadImage(InputStream inp) {
        if (this.gif != null && this.gif.isAlive()) {
            this.gif.interrupt();
        }
        this.mc.execute(() -> {
            try {
                ByteArrayInputStream is = ImageUtil.convertToByteArrayIS(inp);
                if (!this.shouldKeepSize || this.func_230998_h_() == 0 || this.getHeight() == 0) {
                    BufferedImage img = ImageIO.read(is);
                    this.func_230991_b_(img.getWidth());
                    this.setHeight(img.getHeight());
                }
                is.reset();
                do {
                    this.image = new DynamicTexture(this.func_230998_h_(), this.getHeight(), true);
                } while (this.image.func_195414_e().func_227796_e_().length == 0);
                this.mc.execute(() -> ((DynamicTexture)this.image).func_110564_a());
                this.imgLoaded = false;
                this.errorTooltip = "";
                this.acceptsNewImage = false;
                Thread t = new Thread(() -> {
                    try {
                        if (ImageUtil.isISGif(is)) {
                            this.gif = new GifThread(is, this.image, this.keepAspectRatio, this.doGifLoop, this.resizingImage);
                            this.gif.start();
                        } else {
                            try {
                                do {
                                    this.image.func_195415_a(ImageUtil.getImageFromIS(is, this.keepAspectRatio, this.func_230998_h_(), this.getHeight(), this.resizingImage));
                                } while (this.image.func_195414_e().func_227796_e_().length == 0);
                                this.mc.execute(() -> ((DynamicTexture)this.image).func_110564_a());
                                is.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
                        this.resLoc = null;
                        this.acceptsNewImage = true;
                        return;
                    }
                    this.resLoc = this.mc.func_110434_K().func_110578_a("image_" + this.imageUUID.toString().toLowerCase(), this.image);
                    this.acceptsNewImage = true;
                    this.imgLoaded = true;
                });
                t.setDaemon(true);
                t.setName("Image loader " + this.imageUUID.toString());
                t.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void loadImage(URL url) {
        this.loadImage(url.toString());
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (!this.errorTooltip.isEmpty()) {
            int c = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 30).getRGB();
            GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)this.func_230927_p_(), (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.field_230688_j_), (int)(this.getY() + this.field_230689_k_), (int)c, (int)c);
            this.mc.func_110434_K().func_110577_a(errorIcon);
            Image.func_238463_a_((MatrixStack)matrixStack, (int)(this.getX() + this.func_230998_h_() / 2 - 8), (int)(this.getY() + this.getHeight() / 2 - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            return;
        }
        if (this.imgLoaded) {
            if (this.image == null) {
                int c = new Color(Color.DARK_GRAY.getRed(), Color.DARK_GRAY.getGreen(), Color.DARK_GRAY.getBlue(), 40).getRGB();
                GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)this.func_230927_p_(), (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.field_230688_j_), (int)(this.getY() + this.field_230689_k_), (int)c, (int)c);
                return;
            }
            if (this.loadingGif != null && this.loadingGif.isAlive()) {
                this.loadingGif.interrupt();
            }
            this.mc.func_110434_K().func_110577_a(this.resLoc);
            Image.func_238463_a_((MatrixStack)matrixStack, (int)this.getX(), (int)this.getY(), (float)0.0f, (float)0.0f, (int)this.func_230998_h_(), (int)this.getHeight(), (int)this.func_230998_h_(), (int)this.getHeight());
        } else {
            if (this.loadingGif == null || !this.loadingGif.isAlive()) {
                try {
                    this.loadingGif = new GifThread(ImageUtil.convertToByteArrayIS(this.mc.func_195551_G().func_199002_a(new ResourceLocation("eguilib", "textures/gui/loading.gif")).func_199027_b()), this.loadingTexture, this.keepAspectRatio, this.doGifLoop, this.resizingImage);
                }
                catch (IOException c) {
                    // empty catch block
                }
            }
            if (!this.loadingGif.isAlive()) {
                this.loadingGif.start();
            }
            int c = new Color(Color.DARK_GRAY.getRed(), Color.DARK_GRAY.getGreen(), Color.DARK_GRAY.getBlue(), 40).getRGB();
            GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)this.func_230927_p_(), (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.field_230688_j_), (int)(this.getY() + this.field_230689_k_), (int)c, (int)c);
            this.mc.func_110434_K().func_110577_a(this.mc.func_110434_K().func_110578_a("loading-gif_" + this.imageUUID.toString().toLowerCase(), this.loadingTexture));
            Image.func_238463_a_((MatrixStack)matrixStack, (int)(this.getX() + this.func_230998_h_() / 2 - 16), (int)(this.getY() + this.getHeight() / 2 - 16), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        }
    }

    @Override
    public final void mouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.isEnabled()) {
            this.onClick();
        }
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
    }

    @Override
    public void unload() {
        if (this.gif != null && this.gif.isAlive()) {
            this.gif.interrupt();
        }
        if (this.loadingGif != null && this.loadingGif.isAlive()) {
            this.loadingGif.interrupt();
        }
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }

    public void onClick() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }
}

