/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.BossInfo;

public class ProgressBar
extends GuiComponent {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private boolean showPercentText = true;
    private String text = "";
    private BossInfo.Color color = BossInfo.Color.BLUE;
    private int maxValue = 100;
    private int value = 0;
    private int precision = 1;

    public ProgressBar(int x, int y, int widthIn) {
        super(x, y, widthIn, 15);
    }

    public void setMaxValue(int maxValue) {
        if (maxValue <= 0) {
            throw new IllegalArgumentException("Max value can not be smaller than 1");
        }
        this.maxValue = maxValue;
        if (this.value > maxValue) {
            this.value = maxValue;
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(BossInfo.Color color) {
        this.color = color;
    }

    public void setShowPercentText(boolean showPercentText) {
        this.showPercentText = showPercentText;
    }

    @Override
    public void setHeight(int height) {
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
        int progress = (int)(this.getPercent() * (float)this.func_230998_h_());
        for (int w = 0; w <= this.func_230998_h_(); ++w) {
            if (w == 0) {
                this.func_238474_b_(matrixStack, this.getX(), this.getY() + 10, 0, this.color.ordinal() * 5 * 2, 1, 5);
                if (progress <= 0) continue;
                this.func_238474_b_(matrixStack, this.getX(), this.getY() + 10, 0, this.color.ordinal() * 5 * 2 + 5, 1, 5);
                continue;
            }
            if (w == this.func_230998_h_()) {
                this.func_238474_b_(matrixStack, this.getX() + w, this.getY() + 10, 182, this.color.ordinal() * 5 * 2, 1, 5);
                if ((float)progress != 1.0f) continue;
                this.func_238474_b_(matrixStack, this.getX() + w, this.getY() + 10, 182, this.color.ordinal() * 5 * 2 + 5, 1, 5);
                continue;
            }
            this.func_238474_b_(matrixStack, this.getX() + w, this.getY() + 10, 5, this.color.ordinal() * 5 * 2, 1, 5);
            if (progress < w) continue;
            this.func_238474_b_(matrixStack, this.getX() + w, this.getY() + 10, 5, this.color.ordinal() * 5 * 2 + 5, 1, 5);
        }
        String val = String.valueOf(this.getPercent() * 100.0f);
        if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
            if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                val = val.substring(0, val.indexOf(".") + this.precision);
            }
        } else {
            while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                val = val + "0";
            }
        }
        String s = this.text + (this.showPercentText ? " " + val + "%" : "");
        int l = this.mc.field_71466_p.func_78256_a(s);
        this.mc.field_71466_p.func_238405_a_(matrixStack, s, (float)(this.getX() + (this.func_230998_h_() / 2 - l / 2)), (float)this.getY(), 0xFFFFFF);
    }

    private float getPercent() {
        return (float)this.value / (float)this.maxValue;
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }

    public void increment(int value) {
        this.value = Math.min(this.maxValue, this.value + value);
    }

    public void decrement(int value) {
        this.value = Math.max(0, this.value - value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = Math.min(value, this.maxValue);
    }
}

