/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import de.erdbeerbaerlp.guilib.components.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;

public class ScrollPanel
extends GuiComponent {
    protected final int border = 4;
    private final int barWidth = 6;
    private final ArrayList<GuiComponent> components = new ArrayList();
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected float scrollDistance;
    protected boolean captureMouse = true;
    private ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("minecraft", "textures/gui/options_background.png");
    private int barLeft;
    private boolean scrolling;
    private int contentHeight;
    private final ArrayList<String> tooltips = new ArrayList();

    public ScrollPanel(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.contentHeight = height;
        this.recalc();
    }

    private void recalc() {
        this.top = this.getY();
        this.left = this.getX();
        this.bottom = this.field_230689_k_ + this.top;
        this.right = this.field_230688_j_ + this.left;
        this.barLeft = this.left + this.func_230998_h_() - 6;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.recalc();
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.recalc();
    }

    public void setBackgroundTexture(ResourceLocation bg) {
        this.BACKGROUND_LOCATION = bg;
    }

    @Override
    public void unload() {
        for (GuiComponent c : this.components) {
            c.unload();
        }
    }

    @Override
    public void func_230991_b_(int width) {
        super.func_230991_b_(width);
        this.recalc();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.recalc();
    }

    protected int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        this.recalc();
    }

    public final void addComponent(GuiComponent component) {
        this.components.add(component);
    }

    protected void drawBackground() {
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.field_230689_k_ - this.border);
    }

    private void applyScrollLimits() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0) {
            this.scrollDistance = (float)((double)this.scrollDistance + -scroll * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    protected void drawPanel(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (GuiComponent c : this.components) {
            c.scrollOffsetY = this.getY() - (int)this.scrollDistance;
            c.scrollOffsetX = this.getX();
            if (!c.isVisible()) continue;
            c.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void fitContent() {
        for (GuiComponent c : this.components) {
            if (c.getY() - c.scrollOffsetY + c.getHeight() + 10 <= this.contentHeight) continue;
            this.contentHeight = c.getY() - c.scrollOffsetY + c.getHeight() + 10;
        }
    }

    @Override
    public boolean canHaveTooltip() {
        return true;
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
        this.scrolling = false;
        if (mouseX >= (double)this.left && mouseX <= (double)this.right) {
            for (GuiComponent comp : this.components) {
                if (!comp.isVisible()) continue;
                comp.func_231048_c_(mouseX, mouseY, state);
            }
        }
    }

    public final void addAllComponents(GuiComponent ... components) {
        for (GuiComponent c : components) {
            this.addComponent(c);
        }
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.isEnabled()) {
            for (GuiComponent comp : this.components) {
                comp.func_231042_a_(typedChar, keyCode);
            }
        }
        return true;
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.isEnabled()) {
            for (GuiComponent comp : this.components) {
                comp.func_231046_a_(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        for (GuiComponent comp : this.components) {
            comp.func_223281_a_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    private boolean isMouseInComponent(double mouseX, double mouseY, GuiComponent comp) {
        return mouseX >= (double)comp.getX() && mouseY >= (double)comp.getY() && mouseX < (double)(comp.getX() + comp.func_230998_h_()) && mouseY < (double)(comp.getY() + comp.getHeight());
    }

    private int getBarHeight() {
        int barHeight = this.field_230689_k_ * this.field_230689_k_ / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.field_230689_k_ - 8) {
            barHeight = this.field_230689_k_ - 8;
        }
        return barHeight;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isEnabled() && this.scrolling) {
            int maxScroll = this.field_230689_k_ - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected ResourceLocation getBackground() {
        return this.BACKGROUND_LOCATION;
    }

    @Override
    public final void mouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.isEnabled()) {
            boolean bl = this.scrolling = mouseButton == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + 6);
            if (this.scrolling) {
                return;
            }
            if (mouseX >= (double)this.left && mouseX <= (double)this.right) {
                for (GuiComponent comp : this.components) {
                    if ((!comp.isVisible() || !this.isMouseInComponent(mouseX, mouseY, comp)) && !(comp instanceof TextField)) continue;
                    comp.func_231044_a_(mouseX, mouseY, mouseButton);
                }
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        double scale = this.mc.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.mc.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.field_230688_j_ * scale)), (int)((int)((double)this.field_230689_k_ * scale)));
        if (this.mc.field_71441_e != null) {
            this.drawGradientRect(matrixStack, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            RenderSystem.disableLighting();
            RenderSystem.disableFog();
            this.mc.func_110434_K().func_110577_a(this.getBackground());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float texScale = 32.0f;
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.left, (double)this.bottom, 0.0).func_225583_a_((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            worldr.func_225582_a_((double)this.right, (double)this.bottom, 0.0).func_225583_a_((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            worldr.func_225582_a_((double)this.right, (double)this.top, 0.0).func_225583_a_((float)this.right / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            worldr.func_225582_a_((double)this.left, (double)this.top, 0.0).func_225583_a_((float)this.left / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tess.func_78381_a();
        }
        this.drawPanel(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.field_230689_k_;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.field_230689_k_ - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
        for (GuiComponent comp : Lists.reverse(this.components)) {
            this.tooltips.clear();
            if (!comp.isVisible() || !comp.canHaveTooltip() || !this.isMouseInComponent(mouseX, mouseY, comp) || comp.getTooltips() == null) continue;
            this.tooltips.addAll(Arrays.asList(comp.getTooltips()));
            break;
        }
    }

    @Override
    public String[] getTooltips() {
        return this.tooltips.toArray(new String[0]);
    }

    protected void drawGradientRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int color1, int color2) {
        GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)0, (int)left, (int)top, (int)right, (int)bottom, (int)color1, (int)color2);
    }
}

