/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Slider
extends GuiComponent {
    protected final String dispString;
    protected final String suffix;
    protected final int precision;
    protected Runnable action;
    protected double prevValue;
    protected double minValue;
    protected double maxValue;
    protected double sliderValue;
    protected boolean showDecimal;
    protected String displayString;
    protected boolean drawString;
    protected boolean dragging = false;

    public Slider(int xPos, int yPos, String prefix, double minVal, double maxVal, double currentVal, Runnable changeAction) {
        this(xPos, yPos, 150, 20, prefix, "", minVal, maxVal, currentVal, true, true, changeAction);
    }

    public Slider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr) {
        this(xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, null);
    }

    public Slider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Runnable changeAction) {
        super(xPos, yPos, width, height);
        String val;
        this.action = changeAction;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = this.prevValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        this.displayString = this.dispString + val + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.displayString = "";
        }
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setShowDecimal(boolean showDecimal) {
        this.showDecimal = showDecimal;
    }

    public void updateSlider() {
        String val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                    val = val.substring(0, val.indexOf(".") + this.precision);
                }
            } else {
                while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.displayString = this.dispString + val + this.suffix;
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.displayString));
        }
        if (this.prevValue != this.getValue()) {
            this.onValueChanged();
        }
        this.prevValue = this.getValue();
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
        this.updateSlider();
    }

    public void onValueChanged() {
        if (this.action != null) {
            this.action.run();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        int color = 0xE0E0E0;
        boolean bl = this.field_230692_n_ = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.field_230688_j_ && mouseY < this.getY() + this.field_230689_k_;
        if (this.packedFGColor != 0) {
            color = this.packedFGColor;
        } else if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.hovered) {
            color = 0xFFFFA0;
        }
        this.mc.func_110434_K().func_110577_a(field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_238474_b_(matrixStack, this.getX(), this.getY(), 0, 46, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_238474_b_(matrixStack, this.getX() + this.field_230688_j_ / 2, this.getY(), 200 - this.field_230688_j_ / 2, 46, this.field_230688_j_ / 2, this.field_230689_k_);
        if (this.dragging) {
            this.sliderValue = (float)(mouseX - (this.getX() + 4)) / (float)(this.field_230688_j_ - 8);
            this.updateSlider();
        }
        if (this.isEnabled()) {
            int i = (this.func_230449_g_() ? 2 : 1) * 20;
            this.func_238474_b_(matrixStack, this.getX() + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.getY(), 0, 46 + i, 4, 20);
            this.func_238474_b_(matrixStack, this.getX() + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.getY(), 196, 46 + i, 4, 20);
        }
        int bx = this.getX();
        int mwidth = this.field_230688_j_;
        String buttonText = this.displayString;
        int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
        if (strWidth > mwidth - 6 && strWidth > ellipsisWidth) {
            buttonText = this.mc.field_71466_p.func_238412_a_(buttonText, mwidth - 6 - ellipsisWidth).trim() + "...";
        }
        Slider.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)buttonText, (int)(bx + mwidth / 2), (int)(this.getY() + (this.field_230689_k_ - 8) / 2), (int)color);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        this.playPressSound();
        if (this.isEnabled()) {
            this.sliderValue = (mouseX - (double)(this.getX() + 4)) / (double)(this.field_230688_j_ - 8);
            this.updateSlider();
            this.dragging = true;
        }
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
        this.dragging = false;
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        if (this.sliderValue > maxValue) {
            this.sliderValue = maxValue;
        }
        this.updateSlider();
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        if (this.sliderValue < minValue) {
            this.sliderValue = minValue;
        }
        this.updateSlider();
    }
}

