/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TextField
extends GuiComponent {
    protected final boolean canLoseFocus = true;
    final char colorCodePlaceholder = (char)888;
    private final ArrayList<String> suggestions = new ArrayList();
    private final String[] colorCodeSuggestions = new String[]{"\u00a711", "\u00a722", "\u00a733", "\u00a744", "\u00a755", "\u00a766", "\u00a777", "\u00a788", "\u00a799", "\u00a7AA", "\u00a7BB", "\u00a7CC", "\u00a7DD", "\u00a7EE", "\u00a7FF", "\u00a7LL", "\u00a7MM", "\u00a7NN", "\u00a7OO", "K\u00a7kK"};
    protected String text = "";
    protected int maxStringLength = 100;
    protected int cursorCounter;
    protected boolean enableBackgroundDrawing = true;
    protected boolean isFocused;
    protected int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    protected int enabledColor = 0xE0E0E0;
    protected int disabledColor = 0x707070;
    protected Predicate<String> validator = s -> true;
    private Consumer<String> guiResponder;
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;
    private boolean acceptsColors = false;
    private Runnable callback;
    private boolean isShiftDown;
    private boolean showSuggestions = true;
    private int selectedSuggestion = 0;
    private String label = "";

    public TextField(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public TextField(int x, int y, int width) {
        this(x, y, width, 20);
    }

    public void addSuggestion(String suggestion) {
        if (!this.suggestions.contains(suggestion)) {
            this.suggestions.add(suggestion);
        }
    }

    public void addSuggestions(String ... suggestions) {
        for (String s : suggestions) {
            if (this.suggestions.contains(s)) continue;
            this.suggestions.add(s);
        }
    }

    public void removeSuggestion(String suggestion) {
        this.suggestions.remove(suggestion);
    }

    public void enableSuggestions() {
        this.showSuggestions = true;
    }

    public void disableSuggestions() {
        this.showSuggestions = false;
    }

    public boolean isShowingSuggestions() {
        return this.showSuggestions;
    }

    public ArrayList<String> getSuggestions() {
        return this.suggestions;
    }

    public String getCurrentSuggestion() {
        if (this.acceptsColors && this.text.endsWith("\u00a7")) {
            if (this.selectedSuggestion < 0) {
                this.selectedSuggestion = this.colorCodeSuggestions.length - 1;
            }
            if (this.selectedSuggestion >= this.colorCodeSuggestions.length) {
                this.selectedSuggestion = 0;
            }
            return this.colorCodeSuggestions[this.selectedSuggestion];
        }
        if (!this.suggestions.isEmpty()) {
            ArrayList<String> fittingSuggestions = new ArrayList<String>();
            for (String s : this.suggestions) {
                if (!s.startsWith(this.text)) continue;
                fittingSuggestions.add(s);
            }
            if (this.selectedSuggestion < 0) {
                this.selectedSuggestion = fittingSuggestions.size();
            }
            if (fittingSuggestions.size() < this.selectedSuggestion) {
                this.selectedSuggestion = 0;
            }
            if (fittingSuggestions.isEmpty()) {
                return "";
            }
            return (String)fittingSuggestions.get(this.selectedSuggestion);
        }
        return "";
    }

    public void setAcceptsColors(boolean acceptsColors) {
        this.acceptsColors = acceptsColors;
    }

    public void setResponder(Consumer<String> rssponderIn) {
        this.guiResponder = rssponderIn;
    }

    public void setTextFormatter(BiFunction<String, Integer, String> textFormatterIn) {
        this.textFormatter = textFormatterIn;
    }

    protected IFormattableTextComponent func_230442_c_() {
        String s = this.func_230458_i_().getString();
        return new StringTextComponent(s.isEmpty() ? "" : I18n.func_135052_a((String)"gui.narrate.editBox", (Object[])new Object[]{s, this.text}));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> validatorIn) {
        this.validator = validatorIn;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        if (this.acceptsColors) {
            textToWrite = textToWrite.replace('\u00a7', '\u0378');
        }
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        if (this.acceptsColors) {
            s1 = s1.replace('\u0378', '\u00a7');
        }
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.validator.test(s)) {
            this.text = s;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (this.guiResponder != null) {
            this.guiResponder.accept(newText);
        }
        this.field_230696_r_ = Util.func_211177_b() + 500L;
    }

    private void delete(int p_212950_1_) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = this.text.substring(0, i);
                }
                if (j < this.text.length()) {
                    s = s + this.text.substring(j);
                }
                if (this.validator.test(s)) {
                    this.text = s;
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                    this.onTextChanged(this.text);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean func_231042_a_(char character, int keyCode) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.acceptsColors && character == '\u00a7') {
            character = (char)888;
        }
        if (SharedConstants.func_71566_a((char)character)) {
            if (this.isEnabled()) {
                if (this.acceptsColors && character == '\u0378') {
                    character = (char)167;
                }
                this.writeText(Character.toString(character));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.getEnableBackgroundDrawing()) {
            TextField.func_238467_a_((MatrixStack)matrixStack, (int)(this.getX() - 1), (int)(this.getY() - 1), (int)(this.getX() + this.field_230688_j_ + 1), (int)(this.getY() + this.field_230689_k_ + 1), (int)-6250336);
            TextField.func_238467_a_((MatrixStack)matrixStack, (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.field_230688_j_), (int)(this.getY() + this.field_230689_k_), (int)-16777216);
        }
        int currentColor = this.isEnabled() ? this.enabledColor : this.disabledColor;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.func_230999_j_() && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.enableBackgroundDrawing ? this.getX() + 4 : this.getX();
        int i1 = this.enableBackgroundDrawing ? this.getY() + (this.field_230689_k_ - 8) / 2 : this.getY();
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.fontRenderer.func_238405_a_(matrixStack, this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, currentColor);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.field_230688_j_ : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            this.fontRenderer.func_238405_a_(matrixStack, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, currentColor);
        }
        if (!flag2 && !this.getCurrentSuggestion().isEmpty()) {
            this.fontRenderer.func_238405_a_(matrixStack, this.getCurrentSuggestion(), (float)(k1 - 1), (float)i1, -8355712);
        }
        if (!this.label.isEmpty()) {
            this.fontRenderer.func_238421_b_(matrixStack, this.label, (float)this.getX(), (float)(this.getY() - 8), currentColor);
        }
        if (flag1) {
            if (flag2) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
            } else {
                this.fontRenderer.func_238405_a_(matrixStack, "_", (float)k1, (float)i1, currentColor);
            }
        }
        if (k != j) {
            int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
            this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.getX() + this.field_230688_j_) {
            endX = this.getX() + this.field_230688_j_;
        }
        if (startX > this.getX() + this.field_230688_j_) {
            startX = this.getX() + this.field_230688_j_;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.isVisible()) {
            boolean isHovered = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.field_230688_j_) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.field_230689_k_);
            ((Object)((Object)this)).getClass();
            super.func_230996_d_(isHovered);
            if (this.func_230999_j_() && isHovered && mouseButton == 0) {
                int i = MathHelper.func_76128_c((double)mouseX) - this.getX();
                if (this.enableBackgroundDrawing) {
                    i -= 4;
                }
                String s = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
                this.setCursorPosition(this.fontRenderer.func_238412_a_(s, i).length() + this.lineScrollOffset);
            }
        }
    }

    @Override
    public void mouseRelease(double mouseX, double mouseY, int state) {
    }

    public boolean func_231049_c__(boolean p_changeFocus_1_) {
        return this.field_230694_p_ && this.isEnabled() && super.func_231049_c__(p_changeFocus_1_);
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.isShiftDown) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void setTextColor(int color) {
        this.enabledColor = color;
    }

    public void setDisabledTextColour(int color) {
        this.disabledColor = color;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.field_230688_j_ - 8 : this.field_230688_j_;
    }

    private boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean enableBackgroundDrawingIn) {
        this.enableBackgroundDrawing = enableBackgroundDrawingIn;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_238413_a_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.isShiftDown = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            if (this.isEnabled()) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.isEnabled()) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                this.onReturn();
                return true;
            }
            case 259: {
                if (this.isEnabled()) {
                    this.isShiftDown = false;
                    this.delete(-1);
                    this.isShiftDown = Screen.func_231173_s_();
                }
                return true;
            }
            case 265: {
                ++this.selectedSuggestion;
                return false;
            }
            case 264: {
                --this.selectedSuggestion;
                return false;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEnabled()) {
                    this.isShiftDown = false;
                    this.delete(1);
                    this.isShiftDown = Screen.func_231173_s_();
                }
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public void onReturn() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public final void setReturnAction(Runnable r) {
        this.callback = r;
    }

    public boolean canWrite() {
        return this.isVisible() && this.func_230999_j_() && this.isEnabled();
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

