/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.Button;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ToggleButton
extends Button {
    private boolean value = false;
    private DrawType drawType = DrawType.COLORED_LINE;
    private ResourceLocation offIcon = null;

    public ToggleButton(int xPos, int yPos, String displayString) {
        this(xPos, yPos, 100, displayString);
    }

    public ToggleButton(int xPos, int yPos, int width, String displayString) {
        this(xPos, yPos, width, 20, displayString);
    }

    public ToggleButton(int xPos, int yPos, int width, String displayString, ResourceLocation icon) {
        this(xPos, yPos, width, 20, displayString, icon);
    }

    public ToggleButton(int xPos, int yPos, int width, int height, String displayString) {
        this(xPos, yPos, width, height, displayString, (ResourceLocation)null);
    }

    public ToggleButton(int xPos, int yPos, int width, int height, String displayString, ResourceLocation icon) {
        super(xPos, yPos, width, height, displayString, icon);
    }

    public ToggleButton(int xPos, int yPos, String string, ResourceLocation icon) {
        this(xPos, yPos, 100, string, icon);
    }

    public ToggleButton(int xPos, int yPos, ResourceLocation onIcon, ResourceLocation offIcon) {
        this(xPos, yPos, 20, "", onIcon);
        this.offIcon = offIcon;
        this.drawType = DrawType.STRING_OR_ICON;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        int color = 0xE0E0E0;
        boolean bl = this.field_230692_n_ = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.field_230688_j_ && mouseY < this.getY() + this.field_230689_k_;
        if (this.packedFGColor != 0) {
            color = this.packedFGColor;
        } else if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.hovered) {
            color = 0xFFFFA0;
        }
        this.mc.func_110434_K().func_110577_a(field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        int i = this.func_230989_a_(this.func_230449_g_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_238474_b_(matrixStack, this.getX(), this.getY(), 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_238474_b_(matrixStack, this.getX() + this.field_230688_j_ / 2, this.getY(), 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_230441_a_(matrixStack, this.mc, mouseX, mouseY);
        int j = this.getFGColor();
        int bx = this.getX();
        int mwidth = this.field_230688_j_;
        if (this.BUTTON_ICON != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.offIcon != null && (this.drawType == DrawType.STRING_OR_ICON || this.drawType == DrawType.BOTH) ? (this.value ? this.BUTTON_ICON : this.offIcon) : this.BUTTON_ICON);
            ToggleButton.func_238463_a_((MatrixStack)matrixStack, (int)(bx + 2), (int)(this.getY() + 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            bx += 18;
            mwidth -= 16;
        }
        String buttonText = this.displayString;
        int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
        if (strWidth > mwidth - 6 && strWidth > ellipsisWidth) {
            buttonText = this.mc.field_71466_p.func_238412_a_(buttonText, mwidth - 6 - ellipsisWidth).trim() + "...";
        }
        ToggleButton.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)(buttonText + ((this.drawType == DrawType.STRING_OR_ICON || this.drawType == DrawType.BOTH) && this.offIcon == null ? (this.value ? "ON" : "OFF") : "")), (int)(bx + mwidth / 2), (int)(this.getY() + (this.field_230689_k_ - 8) / 2), (int)color);
        if (this.drawType == DrawType.COLORED_LINE || this.drawType == DrawType.BOTH) {
            int col = this.value ? Color.GREEN.getRGB() : Color.red.getRGB();
            GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)this.func_230927_p_(), (int)(this.getX() + 6), (int)(this.getY() + this.field_230689_k_ - 3), (int)(this.getX() + this.field_230688_j_ - 6), (int)(this.getY() + this.field_230689_k_ - 4), (int)col, (int)col);
        }
    }

    public void setDrawType(DrawType type) {
        this.drawType = type;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.field_230694_p_ && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.field_230688_j_) && mouseY < (double)(this.getY() + this.field_230689_k_)) {
            this.playPressSound();
            this.value = !this.value;
            this.onClick();
        }
    }

    public static enum DrawType {
        COLORED_LINE,
        STRING_OR_ICON,
        BOTH;


        public String getName() {
            switch (this) {
                case COLORED_LINE: {
                    return "Colored Line";
                }
                case STRING_OR_ICON: {
                    return "String or Icon";
                }
                case BOTH: {
                    return "All";
                }
            }
            return this.name();
        }
    }
}

