/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import de.erdbeerbaerlp.guilib.components.TextField;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class ExtendedScreen
extends Screen {
    private final List<GuiComponent> components = new ArrayList<GuiComponent>();
    private final int nextComponentID = 0;
    private int currentPage = 0;
    private Screen parentGui;
    private boolean unloadOnClose = true;
    private BooleanConsumer confirmCallback;

    public ExtendedScreen(Screen parentGui) {
        super((ITextComponent)new StringTextComponent("An GUI"));
        this.parentGui = parentGui;
        this.buildGui();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public abstract void buildGui();

    public abstract void updateGui();

    public boolean func_231177_au__() {
        return this.doesGuiPauseGame();
    }

    public abstract boolean doesGuiPauseGame();

    public abstract boolean doesEscCloseGui();

    public void nextPage() {
        if (this.currentPage < Integer.MAX_VALUE) {
            ++this.currentPage;
        }
    }

    public void prevPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    public void setPage(int page) {
        if (page < Integer.MAX_VALUE) {
            this.currentPage = page;
        }
    }

    public final void addComponent(GuiComponent component) {
        this.components.add(component);
    }

    public final void addComponent(GuiComponent component, int page) {
        this.components.add(component);
        component.assignToPage(page);
    }

    public final void addAllComponents(GuiComponent ... components) {
        for (GuiComponent c : components) {
            this.addComponent(c);
        }
    }

    public void assignComponentToPage(GuiComponent comp, int page) {
        comp.assignToPage(page);
    }

    @Deprecated
    protected final <T extends Widget> T func_230480_a_(T buttonIn) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final void actionPerformed(Widget button) {
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.isVisible() || !(mouseX >= (double)comp.getX()) || !(mouseY >= (double)comp.getY()) || !(mouseX < (double)(comp.getX() + comp.func_230998_h_())) || !(mouseY < (double)(comp.getY() + comp.getHeight()))) continue;
            comp.func_231043_a_(mouseX, mouseY, scroll);
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.isVisible()) continue;
            comp.func_231045_a_(mouseX, mouseY, mouseButton, deltaX, deltaY);
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.func_223281_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public Screen getParentGui() {
        return this.parentGui;
    }

    public void setParentGui(Screen parentGui) {
        this.parentGui = parentGui;
    }

    public final void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.updateGui();
        this.func_230446_a_(matrixStack);
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.isVisible()) continue;
            comp.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        for (GuiComponent comp : Lists.reverse(this.components)) {
            if (!comp.isVisible() || comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.canHaveTooltip() || !this.isHovered(comp, mouseX, mouseY)) continue;
            StringTextComponent txt = new StringTextComponent("");
            if (comp.getTooltips() != null) {
                for (int i = 0; i < comp.getTooltips().length; ++i) {
                    txt.func_230529_a_((ITextComponent)new StringTextComponent(comp.getTooltips()[i] + (i == comp.getTooltips().length - 1 ? "" : "\n")));
                }
            }
            if (txt.func_150253_a().isEmpty()) continue;
            this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)txt, Math.max(this.field_230708_k_ / 2, 220)), mouseX, mouseY);
            break;
        }
    }

    protected boolean forceDirtBackground() {
        return false;
    }

    protected ResourceLocation getBackground() {
        return field_230663_f_;
    }

    private boolean isHovered(GuiComponent comp, int mouseX, int mouseY) {
        if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) {
            return false;
        }
        int x = comp.getX();
        int y = comp.getY();
        int w = comp.func_230998_h_();
        int h = comp.getHeight();
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    public final GuiComponent getComponent(int index) {
        return this.components.get(index);
    }

    public final void openGui(Screen gui) {
        this.field_230706_i_.func_147108_a(gui);
    }

    public void close() {
        this.openGui(this.parentGui);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.isVisible() || !(mouseX >= (double)comp.getX() && mouseY >= (double)comp.getY() && mouseX < (double)(comp.getX() + comp.func_230998_h_()) && mouseY < (double)(comp.getY() + comp.getHeight())) && !(comp instanceof TextField)) continue;
            comp.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean func_231042_a_(char character, int keyCode) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.func_231042_a_(character, keyCode);
        }
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.mouseRelease(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 256 && this.doesEscCloseGui()) {
            this.field_230706_i_.func_147108_a((Screen)null);
            if (this.field_230706_i_.field_71462_r == null) {
                this.field_230706_i_.func_213228_a(true);
            }
        }
        for (GuiComponent comp : this.components) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        }
        return true;
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        if (this.field_230706_i_.field_71441_e != null && !this.forceDirtBackground()) {
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            RenderSystem.disableLighting();
            RenderSystem.disableFog();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.field_230706_i_.func_110434_K().func_110577_a(this.getBackground());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_(0.0, (double)this.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)this.field_230709_l_ / 32.0f + 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230708_k_, (double)this.field_230709_l_, 0.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)this.field_230709_l_ / 32.0f + 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230708_k_, 0.0, 0.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, matrixStack));
        }
    }

    public boolean func_230455_a_(Style style) {
        return super.func_230455_a_(style);
    }

    public void func_231164_f_() {
        if (this.unloadOnClose) {
            for (GuiComponent comp : this.components) {
                comp.unload();
            }
        }
    }

    private void confirmed(boolean confirmed) {
        this.confirmCallback.accept(confirmed);
        this.openGui(this);
        this.confirmCallback = null;
        this.unloadOnClose = true;
    }

    public final void openURL(String URL2, BooleanConsumer callback) {
        this.confirmCallback = callback;
        this.unloadOnClose = false;
        ConfirmOpenLinkScreen s = new ConfirmOpenLinkScreen(this::confirmed, URL2, true);
        this.openGui((Screen)s);
    }
}

