/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.util;

import guilibshadow.org.imgscalr.Scalr;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.renderer.texture.NativeImage;

public class ImageUtil {
    public static BufferedImage scaleImage(BufferedImage img, int width, int height) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == width && h == height) {
            return img;
        }
        return Scalr.resize(img, Scalr.Method.AUTOMATIC, Scalr.Mode.FIT_EXACT, width, height, new BufferedImageOp[0]);
    }

    public static BufferedImage scaleImageKeepAspectRatio(BufferedImage img, int width, int height) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == width && h == height) {
            return img;
        }
        Dimension scaled = ImageUtil.getScaledDimension(new Dimension(w, h), new Dimension(width, height));
        int newWidth = (int)scaled.getWidth();
        int newHeight = (int)scaled.getHeight();
        return Scalr.resize(img, Scalr.Method.AUTOMATIC, Scalr.Mode.AUTOMATIC, newWidth, newHeight, new BufferedImageOp[0]);
    }

    private static Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = boundary.width;
        int bound_height = boundary.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        byte[] out = os.toByteArray();
        os.close();
        is.close();
        return out;
    }

    public static ByteArrayInputStream getInputStreamFromImageURL(String url) throws IOException {
        HttpURLConnection httpcon = (HttpURLConnection)new URL(url).openConnection();
        httpcon.addRequestProperty("User-Agent", "Minecraft");
        ByteArrayInputStream is = ImageUtil.convertToByteArrayIS(httpcon.getInputStream());
        httpcon.disconnect();
        return is;
    }

    public static ByteArrayInputStream convertToByteArrayIS(InputStream is) throws IOException {
        return new ByteArrayInputStream(ImageUtil.toByteArray(is));
    }

    public static NativeImage getImageFromIS(ByteArrayInputStream is, boolean keepAspectRatio, int width, int height, boolean resizingImage) throws IOException {
        BufferedImage img = ImageIO.read(is);
        is.reset();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (img.getWidth() <= width && img.getHeight() <= height && !resizingImage) {
            ImageIO.write((RenderedImage)img, "png", os);
        } else if (keepAspectRatio) {
            ImageIO.write((RenderedImage)ImageUtil.scaleImageKeepAspectRatio(img, width, height), "png", os);
        } else {
            ImageIO.write((RenderedImage)ImageUtil.scaleImage(img, width, height), "png", os);
        }
        ByteArrayInputStream is2 = new ByteArrayInputStream(os.toByteArray());
        NativeImage imgo = NativeImage.func_195713_a((InputStream)is2);
        is2.close();
        is.reset();
        return imgo;
    }

    public static boolean isISGif(ByteArrayInputStream is) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (reader.getFormatName().endsWith("gif")) {
                iis.close();
                reader.dispose();
                return true;
            }
            reader.dispose();
        }
        iis.close();
        is.reset();
        return false;
    }
}

