/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.date;

import guilibshadow.cafe4j.date.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime {
    private Date date;
    private TimeZone timeZone;
    private Locale locale;
    private Calendar calendar;

    public DateTime(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public DateTime(Date date, TimeZone timeZone, Locale locale) {
        this.date = date;
        this.timeZone = timeZone;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
        this.calendar.setTime(date);
    }

    public DateTime(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public boolean after(DateTime that) {
        return this.getUTCTimeInMillis() > that.getUTCTimeInMillis();
    }

    public boolean before(DateTime that) {
        return this.getUTCTimeInMillis() < that.getUTCTimeInMillis();
    }

    public static DateTime currentDate() {
        TimeZone tz = TimeZone.getDefault();
        Locale locale = Locale.getDefault();
        return DateTime.currentDate(tz, locale);
    }

    public static DateTime currentDate(TimeZone timeZone) {
        Locale locale = Locale.getDefault();
        return DateTime.currentDate(timeZone, locale);
    }

    public static DateTime currentDate(TimeZone timeZone, Locale locale) {
        Date date = new Date();
        return new DateTime(date, timeZone, locale);
    }

    public static DateTime currentDateUTC() {
        return DateTime.currentDate(TimeZone.getTimeZone("UTC"));
    }

    public static DateTime currentDateUTC(Locale locale) {
        return DateTime.currentDate(TimeZone.getTimeZone("UTC"), locale);
    }

    public DateTime dateAfter(int years, int months) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(1, years);
        clone.add(2, months);
        return new DateTime(clone.getTime(), this.timeZone, this.locale);
    }

    public DateTime dateAfter(int years, int months, int days) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(1, years);
        clone.add(2, months);
        clone.add(5, days);
        return new DateTime(clone.getTime(), this.timeZone, this.locale);
    }

    public DateTime dateAfter(int years, int months, int days, int hours, int minutes, int seconds, int millis) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(1, years);
        clone.add(2, months);
        clone.add(5, days);
        clone.add(10, hours);
        clone.add(12, minutes);
        clone.add(13, seconds);
        clone.add(14, millis);
        return new DateTime(clone.getTime(), this.timeZone, this.locale);
    }

    public DateTime daysAfter(int days) {
        return new DateTime(new Date(this.date.getTime() + 86400000L * (long)days), this.timeZone, this.locale);
    }

    public boolean equals(Object that) {
        if (!(that instanceof DateTime)) {
            return false;
        }
        return this.getUTCTimeInMillis() == ((DateTime)that).getUTCTimeInMillis();
    }

    public String format(DateFormat df) {
        return df.format(this.date);
    }

    public String format(String format) {
        return this.format(format, Locale.getDefault());
    }

    public String format(String format, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(format, locale == null ? Locale.getDefault() : locale);
        df.setTimeZone(this.timeZone);
        String dateString = df.format(this.date);
        return dateString;
    }

    public String formatISO8601() {
        return DateUtils.formatISO8601(this.date, this.timeZone);
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public long getUTCTimeInMillis() {
        long time = this.date.getTime();
        int zoneOffset = this.timeZone.getOffset(time);
        return time + (long)zoneOffset;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int hashCode() {
        return Long.valueOf(this.getUTCTimeInMillis()).hashCode();
    }

    public DateTime hoursAfter(int hours) {
        return new DateTime(new Date(this.date.getTime() + 3600000L * (long)hours), this.timeZone, this.locale);
    }

    public DateTime monthsAfter(int months) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(2, months);
        return new DateTime(clone.getTime(), this.timeZone, this.locale);
    }

    public String toString() {
        DateFormat df = DateFormat.getInstance();
        df.setTimeZone(this.timeZone);
        return df.format(this.date) + " " + this.timeZone.getDisplayName();
    }

    public DateTime yearsAfter(int years) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(1, years);
        return new DateTime(clone.getTime(), this.timeZone, this.locale);
    }
}

