/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.date;

import guilibshadow.cafe4j.date.DateTime;
import guilibshadow.cafe4j.string.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private DateUtils() {
    }

    public static Date dateAfter(Date date, int years, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date dateAfter(Date date, int years, int months, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        calendar.add(2, months);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date dateAfter(Date date, int years, int months, int days, int hours, int minutes, int seconds, int millisecs) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        calendar.add(2, months);
        calendar.add(5, days);
        calendar.add(10, hours);
        calendar.add(12, minutes);
        calendar.add(13, seconds);
        calendar.add(14, millisecs);
        return calendar.getTime();
    }

    public static Date daysAfter(Date date, int days) {
        return new Date(date.getTime() + 86400000L * (long)days);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String formatISO8601(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static String formatISO8601(Date date, TimeZone timeZone) {
        SimpleDateFormat df = null;
        if (timeZone != null) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ");
            df.setTimeZone(timeZone);
            String result = df.format(date);
            if (result.endsWith("0000")) {
                return result.replaceAll("[+-]0000$", "Z");
            }
            return result.replaceAll("(\\d{2})(\\d{2})$", "$1:$2");
        }
        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return df.format(date);
    }

    public static Date hoursAfter(Date date, int hours) {
        return new Date(date.getTime() + 3600000L * (long)hours);
    }

    public static boolean isValidDateStr(String date, String format) {
        return DateUtils.isValidDateStr(date, format, Locale.getDefault());
    }

    public static boolean isValidDateStr(String date, String format, Locale locale) {
        if (StringUtils.isNullOrEmpty(date) || StringUtils.isNullOrEmpty(format)) {
            throw new IllegalArgumentException("Null or empty date/format.");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            sdf.setLenient(false);
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static Date monthsAfter(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static DateTime parseISO8601(String input) throws ParseException {
        TimeZone timeZone = null;
        StringBuilder sb = new StringBuilder(30);
        String[] dateParts = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd"};
        String[] timeParts = new String[]{"HH", "HH:mm", "HH:mm:ss"};
        String[] inputs = input.split("-");
        sb.append(dateParts[Math.min(inputs.length - 1, 2)]);
        int timeIndex = input.indexOf("T");
        if (timeIndex > 0) {
            input = input.replace("Z", "+00:00");
            boolean hasTimeZone = false;
            int timeZoneLen = 0;
            String timeStr = input.substring(timeIndex);
            if (timeStr.indexOf("+") > 0 || timeStr.indexOf("-") > 0) {
                hasTimeZone = true;
                timeZoneLen = 5;
                timeZone = TimeZone.getTimeZone("GMT" + input.substring(input.length() - 6));
                input = StringUtils.replaceLast(input, ":", "");
            }
            String[] timeInputs = input.split(":");
            sb.append("'T'");
            sb.append(timeParts[timeInputs.length - 1]);
            int indexOfDot = input.indexOf(".");
            if (indexOfDot > 0) {
                sb.append("'.'");
                int secondFractionLen = input.length() - indexOfDot - 1 - timeZoneLen;
                if (secondFractionLen > 3) {
                    String secondFractionStr = input.substring(indexOfDot, indexOfDot + secondFractionLen + 1);
                    input = input.replace(secondFractionStr, input.substring(indexOfDot, indexOfDot + 4));
                }
                for (int j = secondFractionLen; j > 0; --j) {
                    sb.append("S");
                }
            }
            if (hasTimeZone) {
                sb.append("Z");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(sb.toString());
        return new DateTime(df.parse(input), timeZone);
    }

    public static Date yearsAfter(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }
}

