/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image;

import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.PeekHeadInputStream;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImageIO {
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;

    public static ImageReader getReader(ImageType imgType) {
        return imgType.getReader();
    }

    public static ImageReader getReader(PeekHeadInputStream peekHeadInputStream) {
        ImageType imageType = ImageType.UNKNOWN;
        try {
            imageType = IMGUtils.guessImageType(peekHeadInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (imageType != ImageType.UNKNOWN) {
            return ImageIO.getReader(imageType);
        }
        return null;
    }

    public static ImageWriter getWriter(ImageType imgType) {
        return imgType.getWriter();
    }

    public static BufferedImage read(File file) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        BufferedImage bi = ImageIO.read(fin);
        fin.close();
        return bi;
    }

    public static BufferedImage read(InputStream is) throws Exception {
        ImageType imageType = null;
        boolean closeStream = false;
        if (is instanceof RandomAccessInputStream) {
            imageType = IMGUtils.guessImageType((RandomAccessInputStream)is);
        } else {
            is = new PeekHeadInputStream(is, 4);
            imageType = IMGUtils.guessImageType((PeekHeadInputStream)is);
            closeStream = true;
        }
        BufferedImage bi = null;
        if (imageType != ImageType.UNKNOWN) {
            bi = ImageIO.getReader(imageType).read(is);
        }
        if (closeStream) {
            ((PeekHeadInputStream)is).shallowClose();
        }
        return bi;
    }

    public static BufferedImage read(String path) throws Exception {
        return ImageIO.read(new File(path));
    }

    public static void write(BufferedImage img, OutputStream os, ImageType imageType) throws Exception {
        ImageIO.write(img, os, imageType, ImageParam.DEFAULT_IMAGE_PARAM);
    }

    public static void write(BufferedImage img, OutputStream os, ImageType imageType, ImageParam imageParam) throws Exception {
        ImageWriter imageWriter = ImageIO.getWriter(imageType);
        if (imageWriter != null) {
            imageWriter.setImageParam(imageParam);
            imageWriter.write(img, os);
        }
    }

    private ImageIO() {
    }
}

