/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image;

import guilibshadow.cafe4j.image.ImageColorType;
import guilibshadow.cafe4j.image.options.ImageOptions;
import guilibshadow.cafe4j.image.quant.DitherMethod;
import guilibshadow.cafe4j.image.quant.QuantMethod;
import guilibshadow.cafe4j.image.quant.QuantQuality;
import guilibshadow.cafe4j.util.Builder;
import java.awt.image.BufferedImage;

public class ImageParam {
    private final int width;
    private final int height;
    private final int bitsPerPixel;
    private final ImageColorType colorType;
    private final int[] rgbColorPalette;
    private final byte[][] componentColorPalette;
    private final boolean hasAlpha;
    private final boolean isApplyDither;
    private final int[][] ditherMatrix;
    private final DitherMethod ditherMethod;
    private final QuantMethod quantMethod;
    private final QuantQuality quantQuality;
    private final boolean transparent;
    private final int transparentColor;
    private final boolean hasICCP;
    private final byte[] icc_profile;
    private final boolean containsThumbnail;
    private final BufferedImage[] thumbnails;
    private final ImageOptions imageOptions;
    public static final ImageParam DEFAULT_IMAGE_PARAM = new ImageParamBuilder().build();
    private static final DitherMethod DEFAULT_DITHER_METHOD = DitherMethod.FLOYD_STEINBERG;
    private static final QuantMethod DEFAULT_QUANT_METHOD = QuantMethod.POPULARITY;
    private static final QuantQuality DEFAULT_QUANT_QUALITY = QuantQuality.GOOD;
    private static final int[][] DEFAULT_DITHER_MATRIX = new int[][]{{1, 49, 13, 61, 4, 52, 16, 64}, {33, 17, 45, 29, 36, 20, 48, 32}, {9, 57, 5, 53, 12, 60, 8, 56}, {41, 25, 37, 21, 44, 28, 40, 24}, {3, 51, 15, 63, 2, 50, 14, 62}, {35, 19, 47, 31, 34, 18, 46, 30}, {11, 59, 7, 55, 10, 58, 6, 54}, {43, 27, 39, 23, 42, 26, 38, 22}};

    private ImageParam(ImageParamBuilder builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.bitsPerPixel = builder.bitsPerPixel;
        this.colorType = builder.colorType;
        this.rgbColorPalette = builder.rgbColorPalette;
        this.componentColorPalette = builder.componentColorPalette;
        this.hasAlpha = builder.hasAlpha;
        this.isApplyDither = builder.applyDither;
        this.ditherMatrix = builder.ditherMatrix;
        this.ditherMethod = builder.ditherMethod;
        this.quantMethod = builder.quantMethod;
        this.quantQuality = builder.quantQuality;
        this.transparentColor = builder.transparentColor;
        this.transparent = builder.transparent;
        this.hasICCP = builder.hasICCP;
        this.icc_profile = builder.icc_profile;
        this.containsThumbnail = builder.containsThumbnail;
        this.thumbnails = builder.thumbnails;
        this.imageOptions = builder.imageOptions;
    }

    public boolean containsThumbnail() {
        return this.containsThumbnail;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public static ImageParamBuilder getBuilder() {
        return new ImageParamBuilder();
    }

    public ImageColorType getColorType() {
        return this.colorType;
    }

    public byte[][] getComponentColorPalette() {
        return this.componentColorPalette;
    }

    public int[][] getDitherMatrix() {
        int[][] copy = new int[this.ditherMatrix.length][];
        for (int i = 0; i < this.ditherMatrix.length; ++i) {
            copy[i] = (int[])this.ditherMatrix[i].clone();
        }
        return copy;
    }

    public DitherMethod getDitherMethod() {
        return this.ditherMethod;
    }

    public QuantMethod getQuantMethod() {
        return this.quantMethod;
    }

    public QuantQuality getQuantQuality() {
        return this.quantQuality;
    }

    public byte[] getICCProfile() {
        return this.icc_profile;
    }

    public int getImageHeight() {
        return this.height;
    }

    public ImageOptions getImageOptions() {
        return this.imageOptions;
    }

    public int getImageWidth() {
        return this.width;
    }

    public int[] getRGBColorPalette() {
        return this.rgbColorPalette;
    }

    public BufferedImage[] getThumbnails() {
        return this.thumbnails;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public boolean hasICCP() {
        return this.hasICCP;
    }

    public boolean isApplyDither() {
        return this.isApplyDither;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public static class ImageParamBuilder
    implements Builder<ImageParam> {
        private int width;
        private int height;
        private int bitsPerPixel;
        private ImageColorType colorType = ImageColorType.FULL_COLOR;
        private int[] rgbColorPalette;
        private byte[][] componentColorPalette;
        private boolean hasAlpha = false;
        private boolean applyDither = false;
        private DitherMethod ditherMethod = ImageParam.access$2000();
        private QuantMethod quantMethod = ImageParam.access$2100();
        private QuantQuality quantQuality = ImageParam.access$2200();
        private int[][] ditherMatrix = ImageParam.access$2300();
        private boolean transparent = false;
        private int transparentColor;
        private boolean hasICCP = false;
        private byte[] icc_profile;
        private boolean containsThumbnail = false;
        private BufferedImage[] thumbnails;
        private ImageOptions imageOptions;

        private ImageParamBuilder() {
        }

        public ImageParamBuilder applyDither(boolean applyDither) {
            this.applyDither = applyDither;
            return this;
        }

        public ImageParamBuilder bitsPerPixel(int bitsPerPixel) {
            this.bitsPerPixel = bitsPerPixel;
            return this;
        }

        @Override
        public ImageParam build() {
            return new ImageParam(this);
        }

        public ImageParamBuilder colorType(ImageColorType colorType) {
            this.colorType = colorType;
            return this;
        }

        public ImageParamBuilder componentColorPalette(byte[][] componentPalette) {
            this.componentColorPalette = componentPalette;
            return this;
        }

        public ImageParamBuilder containsThumbnail(boolean containsThumbnail) {
            this.containsThumbnail = containsThumbnail;
            return this;
        }

        public ImageParamBuilder ditherMatrix(int[][] ditherMatrix) {
            this.ditherMatrix = ditherMatrix;
            return this;
        }

        public ImageParamBuilder ditherMethod(DitherMethod ditherMethod) {
            this.ditherMethod = ditherMethod;
            return this;
        }

        public ImageParamBuilder quantMethod(QuantMethod quantMethod) {
            this.quantMethod = quantMethod;
            return this;
        }

        public ImageParamBuilder quantQuanlity(QuantQuality quantQuality) {
            this.quantQuality = quantQuality;
            return this;
        }

        public ImageParamBuilder hasAlpha(boolean hasAlpha) {
            this.hasAlpha = hasAlpha;
            return this;
        }

        public ImageParamBuilder hasICCP(boolean hasICCP) {
            this.hasICCP = hasICCP;
            return this;
        }

        public ImageParamBuilder height(int height) {
            this.height = height;
            return this;
        }

        public ImageParamBuilder iccProfile(byte[] icc_profile) {
            this.icc_profile = icc_profile;
            return this;
        }

        public ImageParamBuilder imageOptions(ImageOptions imageOptions) {
            this.imageOptions = imageOptions;
            return this;
        }

        public void reset() {
            this.width = 0;
            this.height = 0;
            this.bitsPerPixel = 0;
            this.colorType = ImageColorType.FULL_COLOR;
            this.rgbColorPalette = null;
            this.componentColorPalette = null;
            this.hasAlpha = false;
            this.applyDither = false;
            this.ditherMatrix = DEFAULT_DITHER_MATRIX;
            this.ditherMethod = DEFAULT_DITHER_METHOD;
            this.quantMethod = DEFAULT_QUANT_METHOD;
            this.quantQuality = DEFAULT_QUANT_QUALITY;
            this.transparent = false;
            this.transparentColor = 0;
            this.hasICCP = false;
            this.icc_profile = null;
            this.containsThumbnail = false;
            this.thumbnails = null;
            this.imageOptions = null;
        }

        public ImageParamBuilder rgbColorPalette(int[] rgbColorPalette) {
            this.rgbColorPalette = rgbColorPalette;
            return this;
        }

        public ImageParamBuilder thumbnails(BufferedImage[] thumbnails) {
            this.thumbnails = thumbnails;
            return this;
        }

        public ImageParamBuilder transparent(boolean transparent) {
            this.transparent = transparent;
            return this;
        }

        public ImageParamBuilder transparentColor(int transparentColor) {
            this.transparentColor = transparentColor;
            return this;
        }

        public ImageParamBuilder width(int width) {
            this.width = width;
            return this;
        }
    }
}

