/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image;

import guilibshadow.cafe4j.image.reader.BMPReader;
import guilibshadow.cafe4j.image.reader.GIFReader;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.image.reader.JPGReader;
import guilibshadow.cafe4j.image.reader.PCXReader;
import guilibshadow.cafe4j.image.reader.PNGReader;
import guilibshadow.cafe4j.image.reader.TGAReader;
import guilibshadow.cafe4j.image.reader.TIFFReader;
import guilibshadow.cafe4j.image.writer.BMPWriter;
import guilibshadow.cafe4j.image.writer.GIFWriter;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.image.writer.JPGWriter;
import guilibshadow.cafe4j.image.writer.PNGWriter;
import guilibshadow.cafe4j.image.writer.TIFFWriter;
import java.util.HashMap;
import java.util.Map;

public enum ImageType {
    GIF("Gif"){

        @Override
        public String getExtension() {
            return "gif";
        }

        @Override
        public ImageReader getReader() {
            return new GIFReader();
        }

        @Override
        public ImageWriter getWriter() {
            return new GIFWriter();
        }
    }
    ,
    PNG("Png"){

        @Override
        public String getExtension() {
            return "png";
        }

        @Override
        public ImageReader getReader() {
            return new PNGReader();
        }

        @Override
        public ImageWriter getWriter() {
            return new PNGWriter();
        }
    }
    ,
    JPG("Jpeg"){

        @Override
        public String getExtension() {
            return "jpg";
        }

        @Override
        public ImageReader getReader() {
            return new JPGReader();
        }

        @Override
        public ImageWriter getWriter() {
            return new JPGWriter();
        }
    }
    ,
    JPG2000("Jpeg2000"){

        @Override
        public String getExtension() {
            return "jp2";
        }

        @Override
        public ImageReader getReader() {
            throw new UnsupportedOperationException("JPG2000 reader is not implemented.");
        }

        @Override
        public ImageWriter getWriter() {
            throw new UnsupportedOperationException("JPG2000 writer is not implemented.");
        }
    }
    ,
    BMP("Bitmap"){

        @Override
        public String getExtension() {
            return "bmp";
        }

        @Override
        public ImageReader getReader() {
            return new BMPReader();
        }

        @Override
        public ImageWriter getWriter() {
            return new BMPWriter();
        }
    }
    ,
    TGA("Targa"){

        @Override
        public String getExtension() {
            return "tga";
        }

        @Override
        public ImageReader getReader() {
            return new TGAReader();
        }

        @Override
        public ImageWriter getWriter() {
            throw new UnsupportedOperationException("TGA writer is not implemented.");
        }
    }
    ,
    TIFF("Tiff"){

        @Override
        public String getExtension() {
            return "tif";
        }

        @Override
        public ImageReader getReader() {
            return new TIFFReader();
        }

        @Override
        public ImageWriter getWriter() {
            return new TIFFWriter();
        }
    }
    ,
    PCX("Pcx"){

        @Override
        public String getExtension() {
            return "pcx";
        }

        @Override
        public ImageReader getReader() {
            return new PCXReader();
        }

        @Override
        public ImageWriter getWriter() {
            throw new UnsupportedOperationException("PCX writer is not implemented.");
        }
    }
    ,
    UNKNOWN("Unknown"){

        @Override
        public String getExtension() {
            return null;
        }

        @Override
        public ImageReader getReader() {
            throw new UnsupportedOperationException("No reader for unknown image type.");
        }

        @Override
        public ImageWriter getWriter() {
            throw new UnsupportedOperationException("No writer for unknown image type.");
        }
    };

    private static final Map<String, ImageType> stringMap;
    private final String name;

    public static ImageType fromString(String name) {
        return stringMap.get(name);
    }

    private ImageType(String name) {
        this.name = name;
    }

    public abstract String getExtension();

    public abstract ImageReader getReader();

    public abstract ImageWriter getWriter();

    public String toString() {
        return this.name;
    }

    static {
        stringMap = new HashMap<String, ImageType>();
        for (ImageType type : ImageType.values()) {
            stringMap.put(type.toString(), type);
        }
    }
}

