/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.bmp;

import guilibshadow.cafe4j.image.bmp.BmpCompression;
import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.image.ImageMetadata;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class BMPTweaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPTweaker.class);

    private static void readHeader(InputStream is, DataTransferObject DTO) throws IOException {
        DataTransferObject.access$002(DTO, new byte[14]);
        DataTransferObject.access$102(DTO, new byte[40]);
        is.read(DTO.fileHeader);
        is.read(DTO.infoHeader);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream is) throws IOException {
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        ImageMetadata imageMeta = new ImageMetadata();
        DataTransferObject DTO = new DataTransferObject();
        BMPTweaker.readHeader(is, DTO);
        LOGGER.info("... BMP Image Inforamtion starts...");
        LOGGER.info("Image signature: {}", (Object)new String(DTO.fileHeader, 0, 2));
        LOGGER.info("File size: {} bytes", (Object)IOUtils.readInt(DTO.fileHeader, 2));
        LOGGER.info("Reserved1 (2 bytes): {}", (Object)IOUtils.readShort(DTO.fileHeader, 6));
        LOGGER.info("Reserved2 (2 bytes): {}", (Object)IOUtils.readShort(DTO.fileHeader, 8));
        LOGGER.info("Data offset: {}", (Object)IOUtils.readInt(DTO.fileHeader, 10));
        MetadataEntry header = new MetadataEntry("BMP File Header", "Bitmap File Header", true);
        header.addEntry(new MetadataEntry("Image signature", new String(DTO.fileHeader, 0, 2)));
        header.addEntry(new MetadataEntry("File size", IOUtils.readInt(DTO.fileHeader, 2) + " bytes"));
        header.addEntry(new MetadataEntry("Reserved1", IOUtils.readShort(DTO.fileHeader, 6) + ""));
        header.addEntry(new MetadataEntry("Reserved2", IOUtils.readShort(DTO.fileHeader, 8) + ""));
        header.addEntry(new MetadataEntry("Data-offset", "byte " + IOUtils.readInt(DTO.fileHeader, 10)));
        imageMeta.addMetadataEntry(header);
        LOGGER.info("Info header length: {}", (Object)IOUtils.readInt(DTO.infoHeader, 0));
        LOGGER.info("Image width: {}", (Object)IOUtils.readInt(DTO.infoHeader, 4));
        LOGGER.info("Image heigth: {}", (Object)IOUtils.readInt(DTO.infoHeader, 8));
        String alignment = "";
        alignment = IOUtils.readInt(DTO.infoHeader, 8) > 0 ? "BOTTOM_UP" : "TOP_DOWN";
        MetadataEntry infoHeader = new MetadataEntry("BMP Info Header", "Bitmap Information Header", true);
        infoHeader.addEntry(new MetadataEntry("Info-header-lengthen", IOUtils.readInt(DTO.infoHeader, 0) + " bytes"));
        infoHeader.addEntry(new MetadataEntry("Image-alignment", alignment));
        infoHeader.addEntry(new MetadataEntry("Number-of-planes", IOUtils.readShort(DTO.infoHeader, 12) + " planes"));
        infoHeader.addEntry(new MetadataEntry("Bits-per-pixel", IOUtils.readShort(DTO.infoHeader, 14) + " bits per pixel"));
        infoHeader.addEntry(new MetadataEntry("Compression", BmpCompression.fromInt(IOUtils.readInt(DTO.infoHeader, 16)).toString()));
        infoHeader.addEntry(new MetadataEntry("Compessed-image-size", IOUtils.readInt(DTO.infoHeader, 20) + " bytes"));
        infoHeader.addEntry(new MetadataEntry("Horizontal-resolution", IOUtils.readInt(DTO.infoHeader, 24) + " pixels/meter"));
        infoHeader.addEntry(new MetadataEntry("Vertical-resolution", IOUtils.readInt(DTO.infoHeader, 28) + " pixels/meter"));
        infoHeader.addEntry(new MetadataEntry("Colors-used", IOUtils.readInt(DTO.infoHeader, 32) + " colors used"));
        infoHeader.addEntry(new MetadataEntry("Important-colors", IOUtils.readInt(DTO.infoHeader, 36) + " important colors"));
        imageMeta.addMetadataEntry(infoHeader);
        LOGGER.info("Image alignment: {}", (Object)alignment);
        LOGGER.info("Number of planes: {}", (Object)IOUtils.readShort(DTO.infoHeader, 12));
        LOGGER.info("BitCount (bits per pixel): {}", (Object)IOUtils.readShort(DTO.infoHeader, 14));
        LOGGER.info("Compression: {}", (Object)BmpCompression.fromInt(IOUtils.readInt(DTO.infoHeader, 16)));
        LOGGER.info("Image size (compressed size of image): {} bytes", (Object)IOUtils.readInt(DTO.infoHeader, 20));
        LOGGER.info("Horizontal resolution (Pixels/meter): {}", (Object)IOUtils.readInt(DTO.infoHeader, 24));
        LOGGER.info("Vertical resolution (Pixels/meter): {}", (Object)IOUtils.readInt(DTO.infoHeader, 28));
        LOGGER.info("Colors used (number of actually used colors): {}", (Object)IOUtils.readInt(DTO.infoHeader, 32));
        LOGGER.info("Important colors (number of important colors): {}", (Object)IOUtils.readInt(DTO.infoHeader, 36));
        short bitsPerPixel = IOUtils.readShort(DTO.infoHeader, 14);
        if (bitsPerPixel <= 8) {
            BMPTweaker.readPalette(is, DTO);
            LOGGER.info("Color map follows");
        }
        metadataMap.put(MetadataType.IMAGE, imageMeta);
        return metadataMap;
    }

    private static void readPalette(InputStream is, DataTransferObject DTO) throws IOException {
        int index = 0;
        int bindex = 0;
        int colorsUsed = IOUtils.readInt(DTO.infoHeader, 32);
        short bitsPerPixel = IOUtils.readShort(DTO.infoHeader, 14);
        int dataOffset = IOUtils.readInt(DTO.fileHeader, 10);
        int numOfColors = colorsUsed == 0 ? 1 << bitsPerPixel : colorsUsed;
        byte[] palette = new byte[numOfColors * 4];
        DataTransferObject.access$302(DTO, new int[numOfColors]);
        IOUtils.readFully(is, palette);
        for (int i = 0; i < numOfColors; ++i) {
            ((DataTransferObject)DTO).colorPalette[index++] = 0xFF000000 | palette[bindex] & 0xFF | (palette[bindex + 1] & 0xFF) << 8 | (palette[bindex + 2] & 0xFF) << 16;
            bindex += 4;
        }
        IOUtils.skipFully(is, dataOffset - numOfColors * 4 - 54);
    }

    private BMPTweaker() {
    }

    private static class DataTransferObject {
        private byte[] fileHeader;
        private byte[] infoHeader;
        private int[] colorPalette;

        private DataTransferObject() {
        }

        static /* synthetic */ byte[] access$002(DataTransferObject x0, byte[] x1) {
            x0.fileHeader = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(DataTransferObject x0, byte[] x1) {
            x0.infoHeader = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(DataTransferObject x0, int[] x1) {
            x0.colorPalette = x1;
            return x1;
        }
    }
}

