/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.bmp;

import java.util.HashMap;
import java.util.Map;

public enum BmpCompression {
    BI_RGB("No Compression", 0),
    BI_RLE8("8 bit RLE Compression (8 bit only)", 1),
    BI_RLE4("4 bit RLE Compression (4 bit only)", 2),
    BI_BITFIELDS("No compression (16 & 32 bit only)", 3),
    UNKNOWN("Unknown", 9999);

    private static final Map<Integer, BmpCompression> typeMap;
    private String description;
    private int value;

    private BmpCompression(String description, int value) {
        this.description = description;
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.description;
    }

    public static BmpCompression fromInt(int value) {
        BmpCompression compression = typeMap.get(value);
        if (compression == null) {
            return UNKNOWN;
        }
        return compression;
    }

    static {
        typeMap = new HashMap<Integer, BmpCompression>();
        for (BmpCompression compression : BmpCompression.values()) {
            typeMap.put(compression.getValue(), compression);
        }
    }
}

