/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.color;

import java.awt.color.ColorSpace;

public class CMYKColorSpace
extends ColorSpace {
    private static final long serialVersionUID = -4823887516599874355L;
    private static CMYKColorSpace instance;

    public static CMYKColorSpace getInstance() {
        if (instance == null) {
            instance = new CMYKColorSpace(9, 4);
        }
        return instance;
    }

    protected CMYKColorSpace(int type, int numcomponents) {
        super(type, numcomponents);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("fromCIEXYZ is not implemented");
    }

    @Override
    public float[] fromRGB(float[] rgb) {
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float c = 1.0f - r;
        float m = 1.0f - g;
        float y = 1.0f - b;
        float tempK = 1.0f;
        if (c < tempK) {
            tempK = c;
        }
        if (m < tempK) {
            tempK = m;
        }
        if (y < tempK) {
            tempK = y;
        }
        if (tempK == 1.0f) {
            y = 0.0f;
            m = 0.0f;
            c = 0.0f;
        } else {
            c = (c - tempK) / (1.0f - tempK);
            m = (m - tempK) / (1.0f - tempK);
            y = (y - tempK) / (1.0f - tempK);
        }
        return new float[]{c, m, y, tempK};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("toCIEXYZ is not implemented");
    }

    @Override
    public float[] toRGB(float[] cmyk) {
        float c = cmyk[0];
        float m = cmyk[1];
        float y = cmyk[2];
        float k = cmyk[3];
        if (k < 1.0f) {
            c = c * (1.0f - k) + k;
            m = m * (1.0f - k) + k;
            y = y * (1.0f - k) + k;
        } else {
            y = 1.0f;
            m = 1.0f;
            c = 1.0f;
        }
        return new float[]{1.0f - c, 1.0f - m, 1.0f - y};
    }
}

