/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.ccitt;

import guilibshadow.cafe4j.image.compression.ImageDecoder;
import guilibshadow.cafe4j.image.compression.huffman.T4BlackCodeHuffmanTreeNode;
import guilibshadow.cafe4j.image.compression.huffman.T4CodeHuffmanTreeNode;
import guilibshadow.cafe4j.image.compression.huffman.T4WhiteCodeHuffmanTreeNode;

public class G31DDecoder
implements ImageDecoder {
    private int empty_bits = 8;
    private int lineOffset = 0;
    protected byte[] input;
    protected int len;
    protected int scanLineWidth;
    protected int totalRunLen;
    protected int rowsPerStrip;
    protected int byteOffset;
    protected int bitOffset = 7;
    protected int destByteOffset;
    protected int uncompressedBytes;

    public G31DDecoder(int scanLineWidth, int rowsPerStrip) {
        this.scanLineWidth = scanLineWidth;
        this.rowsPerStrip = rowsPerStrip;
    }

    public G31DDecoder(byte[] input, int scanLineWidth, int rowsPerStrip) {
        this.input = input;
        this.scanLineWidth = scanLineWidth;
        this.rowsPerStrip = rowsPerStrip;
        this.reset(0, input.length, 7);
    }

    @Override
    public int decode(byte[] pix, int offset, int len) throws Exception {
        T4CodeHuffmanTreeNode whiteNodes;
        T4CodeHuffmanTreeNode blackNodes = T4BlackCodeHuffmanTreeNode.getInstance();
        T4CodeHuffmanTreeNode currNode = whiteNodes = T4WhiteCodeHuffmanTreeNode.getInstance();
        byte cur = this.input[this.byteOffset];
        int endOffset = this.byteOffset + this.len;
        this.destByteOffset = offset;
        int runLen = 0;
        int remaining = this.scanLineWidth;
        boolean isWhiteCode = true;
        while (true) {
            if ((cur >> this.bitOffset & 1) == 0) {
                if (currNode.left() != null) {
                    currNode = currNode.left();
                    --this.bitOffset;
                    if (this.bitOffset >= 0) continue;
                    this.bitOffset = 7;
                    ++this.byteOffset;
                    if (this.byteOffset >= endOffset) break;
                    cur = this.input[this.byteOffset];
                    continue;
                }
                runLen += currNode.value();
                if (currNode.value() <= 63) {
                    if (runLen > remaining) {
                        runLen = remaining;
                    }
                    remaining -= runLen;
                    if (isWhiteCode) {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                        if (remaining != 0) {
                            currNode = blackNodes;
                            isWhiteCode = false;
                        } else {
                            currNode = whiteNodes;
                            isWhiteCode = true;
                        }
                    } else {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                        currNode = whiteNodes;
                        isWhiteCode = true;
                    }
                    if (remaining == 0) {
                        remaining = this.scanLineWidth;
                        if (this.bitOffset != 7) {
                            ++this.byteOffset;
                            this.bitOffset = 7;
                            if (this.byteOffset >= endOffset) break;
                            cur = this.input[this.byteOffset];
                        }
                    }
                    runLen = 0;
                    continue;
                }
                if (isWhiteCode) {
                    currNode = whiteNodes;
                    continue;
                }
                currNode = blackNodes;
                continue;
            }
            if ((cur >> this.bitOffset & 1) != 1) continue;
            if (currNode.right() != null) {
                currNode = currNode.right();
                --this.bitOffset;
                if (this.bitOffset >= 0) continue;
                this.bitOffset = 7;
                ++this.byteOffset;
                if (this.byteOffset >= endOffset) break;
                cur = this.input[this.byteOffset];
                continue;
            }
            runLen += currNode.value();
            if (currNode.value() <= 63) {
                if (runLen > remaining) {
                    runLen = remaining;
                }
                remaining -= runLen;
                if (isWhiteCode) {
                    this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                    if (remaining != 0) {
                        currNode = blackNodes;
                        isWhiteCode = false;
                    } else {
                        currNode = whiteNodes;
                        isWhiteCode = true;
                    }
                } else {
                    this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                    currNode = whiteNodes;
                    isWhiteCode = true;
                }
                if (remaining == 0) {
                    remaining = this.scanLineWidth;
                    if (this.bitOffset != 7) {
                        ++this.byteOffset;
                        this.bitOffset = 7;
                        if (this.byteOffset >= endOffset) break;
                        cur = this.input[this.byteOffset];
                    }
                }
                runLen = 0;
                continue;
            }
            if (isWhiteCode) {
                currNode = whiteNodes;
                continue;
            }
            currNode = blackNodes;
        }
        if (this.totalRunLen < this.scanLineWidth * this.rowsPerStrip) {
            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, this.scanLineWidth * this.rowsPerStrip - this.totalRunLen, this.scanLineWidth, 0, len);
        }
        return this.uncompressedBytes;
    }

    protected int outputRunLen(byte[] output, int offset, int runLen, int stride, int color, int len) {
        int i = 0;
        for (i = 0; i < runLen && this.uncompressedBytes < len; ++i) {
            if (this.empty_bits >= 1) {
                int n = offset;
                output[n] = (byte)(output[n] | color << this.empty_bits - 1);
                --this.empty_bits;
            }
            if (++this.lineOffset % stride != 0 && this.empty_bits != 0) continue;
            ++offset;
            ++this.uncompressedBytes;
            this.empty_bits = 8;
        }
        this.totalRunLen += i;
        return offset;
    }

    private void reset(int byteOffset, int len, int bitOffset) {
        this.byteOffset = byteOffset;
        this.len = len;
        this.bitOffset = bitOffset;
        this.uncompressedBytes = 0;
        this.totalRunLen = 0;
    }

    @Override
    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    @Override
    public void setInput(byte[] input, int offset, int len) {
        this.input = input;
        this.reset(offset, len, 7);
    }
}

