/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.ccitt;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.ccitt.T4BlackCode;
import guilibshadow.cafe4j.image.compression.ccitt.T4Code;
import guilibshadow.cafe4j.image.compression.ccitt.T4WhiteCode;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.cafe4j.util.CollectionUtils;
import guilibshadow.cafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class G31DEncoder
implements ImageEncoder {
    private int empty_bits;
    private byte[] bytes_buf;
    private int buf_length;
    private OutputStream os;
    private Updatable<Integer> writer;
    private boolean extraFlush;
    private int bufIndex;
    private int compressedDataLen = 0;
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191};
    protected int scanLineWidth;
    protected int currPos = 7;

    public G31DEncoder(OutputStream os, int scanLineWidth, int buf_length, Updatable<Integer> writer) {
        this.scanLineWidth = scanLineWidth;
        this.bytes_buf = new byte[buf_length];
        this.buf_length = buf_length;
        this.os = os;
        this.writer = writer;
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        int numOfScanLines = len / this.scanLineWidth;
        for (int i = 0; i < numOfScanLines; ++i) {
            start = this.encode1DLine(pixels, start);
        }
    }

    protected int encode1DLine(byte[] pixels, int start) throws Exception {
        ArrayList<Integer> runLen = new ArrayList<Integer>();
        ArrayList<Integer> bits = new ArrayList<Integer>();
        int l = 0;
        int offset = 0;
        int k = pixels[start] >>> this.currPos & 1;
        int i = start;
        while (this.currPos >= 0) {
            if ((pixels[i] >>> this.currPos & 1) == k) {
                ++l;
            } else {
                runLen.add(l);
                bits.add(k);
                k = pixels[i] >>> this.currPos & 1;
                l = 1;
            }
            ++offset;
            --this.currPos;
            if (this.currPos < 0) {
                this.currPos = 7;
                ++i;
            }
            if (offset < this.scanLineWidth) continue;
        }
        runLen.add(l);
        bits.add(k);
        int[] runs = CollectionUtils.integerListToIntArray(runLen);
        int[] bitType = CollectionUtils.integerListToIntArray(bits);
        for (int m = 0; m < bitType.length; ++m) {
            int len = runs[m];
            if (bitType[m] == 0) {
                this.outputRunLengthCode(len, 0);
                continue;
            }
            if (m == 0) {
                this.send_code_to_buffer(13568, 8);
            }
            this.outputRunLengthCode(len, 1);
        }
        this.flush_buf(this.bufIndex + 1);
        this.empty_bits = 8;
        return i;
    }

    protected void outputRunLengthCode(int len, int color) throws Exception {
        T4Code code;
        int index;
        if (len >= 2624) {
            index = 104;
            code = color == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[index]) : T4BlackCode.fromRunLen(T4Code.runLenArray[index]);
            short codeValue = code.getCode();
            int codeLen = code.getCodeLen();
            int currRunLen = code.getRunLen();
            while (len >= 2624) {
                this.send_code_to_buffer(codeValue, codeLen);
                len -= currRunLen;
            }
        }
        while (len >= 64) {
            index = 64 + (len >> 6);
            code = color == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[index]) : T4BlackCode.fromRunLen(T4Code.runLenArray[index]);
            this.send_code_to_buffer(code.getCode(), code.getCodeLen());
            len -= code.getRunLen();
        }
        code = color == 0 ? T4WhiteCode.fromRunLen(len) : T4BlackCode.fromRunLen(len);
        this.send_code_to_buffer(code.getCode(), code.getCodeLen());
    }

    protected void outputRunLengthCode2(int len, int color) throws Exception {
        int index = ArrayUtils.findEqualOrLess(T4Code.runLenArray, len);
        while (index > 0) {
            T4Code code = color == 0 ? T4WhiteCode.fromRunLen(T4Code.runLenArray[index]) : T4BlackCode.fromRunLen(T4Code.runLenArray[index]);
            short codeValue = code.getCode();
            int codeLen = code.getCodeLen();
            int currRunLen = code.getRunLen();
            while (len >= currRunLen) {
                this.send_code_to_buffer(codeValue, codeLen);
                len -= currRunLen;
            }
            index = ArrayUtils.findEqualOrLess(T4Code.runLenArray, 0, index, len);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.extraFlush) {
            this.flush_buf(this.bufIndex + 1);
        }
        this.writer.update(this.compressedDataLen);
    }

    private void flush_buf(int len) throws Exception {
        this.os.write(this.bytes_buf, 0, len);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, len, (byte)0);
        this.compressedDataLen += len;
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    @Override
    public void initialize() throws Exception {
        this.empty_bits = 8;
        this.compressedDataLen = 0;
    }

    protected void send_code_to_buffer(int code, int codeLen) throws Exception {
        if (this.empty_bits == 0) {
            if (++this.bufIndex >= this.buf_length) {
                this.flush_buf(this.buf_length);
            }
            this.empty_bits = 8;
        }
        if (codeLen <= this.empty_bits) {
            int shift = 16 - codeLen;
            int n = this.bufIndex;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | (code >>> shift & mask[codeLen]) << this.empty_bits - codeLen);
            this.empty_bits -= codeLen;
        } else {
            int n = this.bufIndex++;
            this.bytes_buf[n] = (byte)(this.bytes_buf[n] | code >>> 16 - this.empty_bits & mask[this.empty_bits]);
            int temp = codeLen - this.empty_bits;
            if (temp > 8) {
                if (this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n2 = this.bufIndex;
                this.bytes_buf[n2] = (byte)(this.bytes_buf[n2] | code >>> 8 - codeLen + temp & mask[8]);
                temp -= 8;
            }
            if (temp > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n3 = this.bufIndex;
                this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (code >>> 16 - codeLen & mask[temp]) << 8 - temp);
                temp -= 8;
            }
            this.empty_bits = -temp;
        }
    }

    protected void setExtraFlush(boolean extraFlush) {
        this.extraFlush = extraFlush;
    }
}

