/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.ccitt;

import guilibshadow.cafe4j.image.compression.ImageDecoder;
import guilibshadow.cafe4j.image.compression.ccitt.G31DDecoder;
import guilibshadow.cafe4j.image.compression.huffman.T4BlackCodeHuffmanTreeNode;
import guilibshadow.cafe4j.image.compression.huffman.T4CodeHuffmanTreeNode;
import guilibshadow.cafe4j.image.compression.huffman.T4WhiteCodeHuffmanTreeNode;

public class G32DDecoder
extends G31DDecoder
implements ImageDecoder {
    private boolean is1DEncoding;

    public G32DDecoder(int scanLineWidth, int rowsPerStrip) {
        this(scanLineWidth, rowsPerStrip, false);
    }

    public G32DDecoder(int scanLineWidth, int rowsPerStrip, boolean is1DEncoding) {
        super(scanLineWidth, rowsPerStrip);
        this.is1DEncoding = is1DEncoding;
    }

    public G32DDecoder(byte[] input, int scanLineWidth, int rowsPerStrip) {
        this(input, scanLineWidth, rowsPerStrip, false);
    }

    public G32DDecoder(byte[] input, int scanLineWidth, int rowsPerStrip, boolean is1DEncoding) {
        super(input, scanLineWidth, rowsPerStrip);
        this.is1DEncoding = is1DEncoding;
    }

    @Override
    public int decode(byte[] pix, int offset, int len) throws Exception {
        if (this.is1DEncoding) {
            return this.decode1D(pix, offset, len);
        }
        return this.decode2D(pix, offset, len);
    }

    private int decode1D(byte[] pix, int offset, int len) throws Exception {
        T4CodeHuffmanTreeNode whiteNodes;
        T4CodeHuffmanTreeNode blackNodes = T4BlackCodeHuffmanTreeNode.getInstance();
        T4CodeHuffmanTreeNode currNode = whiteNodes = T4WhiteCodeHuffmanTreeNode.getInstance();
        byte cur = this.input[this.byteOffset];
        int endOffset = this.byteOffset + this.len;
        this.destByteOffset = offset;
        int runLen = 0;
        int remaining = this.scanLineWidth;
        boolean isWhiteCode = true;
        int markByteOffset = offset;
        int markBitOffset = 7;
        boolean markIsWhiteCode = true;
        T4CodeHuffmanTreeNode markCurrNode = whiteNodes;
        boolean expectEOL = true;
        while (true) {
            if ((cur >> this.bitOffset & 1) == 0) {
                if (currNode.left() != null) {
                    currNode = currNode.left();
                    --this.bitOffset;
                    if (this.bitOffset >= 0) continue;
                    this.bitOffset = 7;
                    ++this.byteOffset;
                    if (this.byteOffset >= endOffset) break;
                    cur = this.input[this.byteOffset];
                    continue;
                }
                if (currNode.value() >= 0) {
                    runLen += currNode.value();
                    if (currNode.value() <= 63) {
                        if (expectEOL) {
                            currNode = markCurrNode;
                            this.byteOffset = markByteOffset;
                            this.bitOffset = markBitOffset;
                            isWhiteCode = markIsWhiteCode;
                            if (this.bitOffset != 7) {
                                ++this.byteOffset;
                                this.bitOffset = 7;
                                if (this.byteOffset >= endOffset) break;
                            }
                            cur = this.input[this.byteOffset];
                            runLen = 0;
                            expectEOL = false;
                            continue;
                        }
                        if (runLen > remaining) {
                            runLen = remaining;
                        }
                        remaining -= runLen;
                        if (isWhiteCode) {
                            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                            if (remaining != 0) {
                                currNode = blackNodes;
                                isWhiteCode = false;
                            } else {
                                currNode = whiteNodes;
                                isWhiteCode = true;
                            }
                        } else {
                            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                            currNode = whiteNodes;
                            isWhiteCode = true;
                        }
                        if (remaining == 0) {
                            remaining = this.scanLineWidth;
                            markByteOffset = this.byteOffset;
                            markBitOffset = this.bitOffset;
                            if (isWhiteCode) {
                                markCurrNode = whiteNodes;
                                markIsWhiteCode = true;
                            } else {
                                markCurrNode = blackNodes;
                                markIsWhiteCode = false;
                            }
                            expectEOL = true;
                        }
                        runLen = 0;
                        continue;
                    }
                    if (isWhiteCode) {
                        currNode = whiteNodes;
                        continue;
                    }
                    currNode = blackNodes;
                    continue;
                }
                if (remaining != this.scanLineWidth) {
                    this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, remaining, this.scanLineWidth, 0, len);
                    remaining = this.scanLineWidth;
                }
                expectEOL = false;
                isWhiteCode = true;
                currNode = whiteNodes;
                continue;
            }
            if ((cur >> this.bitOffset & 1) != 1) continue;
            if (currNode.right() != null) {
                currNode = currNode.right();
                --this.bitOffset;
                if (this.bitOffset >= 0) continue;
                this.bitOffset = 7;
                ++this.byteOffset;
                if (this.byteOffset >= endOffset) break;
                cur = this.input[this.byteOffset];
                continue;
            }
            if (currNode.value() >= 0) {
                runLen += currNode.value();
                if (currNode.value() <= 63) {
                    if (expectEOL) {
                        currNode = markCurrNode;
                        isWhiteCode = markIsWhiteCode;
                        this.byteOffset = markByteOffset;
                        this.bitOffset = markBitOffset;
                        if (this.bitOffset != 7) {
                            ++this.byteOffset;
                            this.bitOffset = 7;
                            if (this.byteOffset >= endOffset) break;
                        }
                        cur = this.input[this.byteOffset];
                        runLen = 0;
                        expectEOL = false;
                        continue;
                    }
                    if (runLen > remaining) {
                        runLen = remaining;
                    }
                    remaining -= runLen;
                    if (isWhiteCode) {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                        if (remaining != 0) {
                            currNode = blackNodes;
                            isWhiteCode = false;
                        } else {
                            currNode = whiteNodes;
                            isWhiteCode = true;
                        }
                    } else {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                        currNode = whiteNodes;
                        isWhiteCode = true;
                    }
                    if (remaining == 0) {
                        remaining = this.scanLineWidth;
                        markByteOffset = this.byteOffset;
                        markBitOffset = this.bitOffset;
                        if (isWhiteCode) {
                            markCurrNode = whiteNodes;
                            markIsWhiteCode = true;
                        } else {
                            markCurrNode = blackNodes;
                            markIsWhiteCode = false;
                        }
                        expectEOL = true;
                    }
                    runLen = 0;
                    continue;
                }
                if (isWhiteCode) {
                    currNode = whiteNodes;
                    continue;
                }
                currNode = blackNodes;
                continue;
            }
            if (remaining != this.scanLineWidth) {
                this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, remaining, this.scanLineWidth, 0, len);
                remaining = this.scanLineWidth;
            }
            expectEOL = false;
            isWhiteCode = true;
            currNode = whiteNodes;
        }
        if (this.totalRunLen < this.scanLineWidth * this.rowsPerStrip) {
            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, this.scanLineWidth * this.rowsPerStrip - this.totalRunLen, this.scanLineWidth, 0, len);
        }
        return this.uncompressedBytes;
    }

    private int decode2D(byte[] pix, int offset, int len) throws Exception {
        T4CodeHuffmanTreeNode whiteNodes;
        T4CodeHuffmanTreeNode blackNodes = T4BlackCodeHuffmanTreeNode.getInstance();
        T4CodeHuffmanTreeNode currNode = whiteNodes = T4WhiteCodeHuffmanTreeNode.getInstance();
        byte cur = this.input[this.byteOffset];
        int endOffset = this.byteOffset + this.len;
        this.destByteOffset = offset;
        int runLen = 0;
        int remaining = this.scanLineWidth;
        boolean isWhiteCode = true;
        int markByteOffset = offset;
        int markBitOffset = 7;
        boolean markIsWhiteCode = true;
        T4CodeHuffmanTreeNode markCurrNode = whiteNodes;
        boolean expectEOL = true;
        while (true) {
            if ((cur >> this.bitOffset & 1) == 0) {
                if (currNode.left() != null) {
                    currNode = currNode.left();
                    --this.bitOffset;
                    if (this.bitOffset >= 0) continue;
                    this.bitOffset = 7;
                    ++this.byteOffset;
                    if (this.byteOffset >= endOffset) break;
                    cur = this.input[this.byteOffset];
                    continue;
                }
                if (currNode.value() >= 0) {
                    runLen += currNode.value();
                    if (currNode.value() <= 63) {
                        if (expectEOL) {
                            currNode = markCurrNode;
                            this.byteOffset = markByteOffset;
                            this.bitOffset = markBitOffset;
                            isWhiteCode = markIsWhiteCode;
                            if (this.bitOffset != 7) {
                                ++this.byteOffset;
                                this.bitOffset = 7;
                                if (this.byteOffset >= endOffset) break;
                            }
                            cur = this.input[this.byteOffset];
                            runLen = 0;
                            expectEOL = false;
                            continue;
                        }
                        if (runLen > remaining) {
                            runLen = remaining;
                        }
                        remaining -= runLen;
                        if (isWhiteCode) {
                            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                            if (remaining != 0) {
                                currNode = blackNodes;
                                isWhiteCode = false;
                            } else {
                                currNode = whiteNodes;
                                isWhiteCode = true;
                            }
                        } else {
                            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                            currNode = whiteNodes;
                            isWhiteCode = true;
                        }
                        if (remaining == 0) {
                            remaining = this.scanLineWidth;
                            markByteOffset = this.byteOffset;
                            markBitOffset = this.bitOffset;
                            if (isWhiteCode) {
                                markCurrNode = whiteNodes;
                                markIsWhiteCode = true;
                            } else {
                                markCurrNode = blackNodes;
                                markIsWhiteCode = false;
                            }
                            expectEOL = true;
                        }
                        runLen = 0;
                        continue;
                    }
                    if (isWhiteCode) {
                        currNode = whiteNodes;
                        continue;
                    }
                    currNode = blackNodes;
                    continue;
                }
                if (remaining != this.scanLineWidth) {
                    this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, remaining, this.scanLineWidth, 0, len);
                    remaining = this.scanLineWidth;
                }
                expectEOL = false;
                isWhiteCode = true;
                currNode = whiteNodes;
                continue;
            }
            if ((cur >> this.bitOffset & 1) != 1) continue;
            if (currNode.right() != null) {
                currNode = currNode.right();
                --this.bitOffset;
                if (this.bitOffset >= 0) continue;
                this.bitOffset = 7;
                ++this.byteOffset;
                if (this.byteOffset >= endOffset) break;
                cur = this.input[this.byteOffset];
                continue;
            }
            if (currNode.value() >= 0) {
                runLen += currNode.value();
                if (currNode.value() <= 63) {
                    if (expectEOL) {
                        currNode = markCurrNode;
                        isWhiteCode = markIsWhiteCode;
                        this.byteOffset = markByteOffset;
                        this.bitOffset = markBitOffset;
                        if (this.bitOffset != 7) {
                            ++this.byteOffset;
                            this.bitOffset = 7;
                            if (this.byteOffset >= endOffset) break;
                        }
                        cur = this.input[this.byteOffset];
                        runLen = 0;
                        expectEOL = false;
                        continue;
                    }
                    if (runLen > remaining) {
                        runLen = remaining;
                    }
                    remaining -= runLen;
                    if (isWhiteCode) {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 0, len);
                        if (remaining != 0) {
                            currNode = blackNodes;
                            isWhiteCode = false;
                        } else {
                            currNode = whiteNodes;
                            isWhiteCode = true;
                        }
                    } else {
                        this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, runLen, this.scanLineWidth, 1, len);
                        currNode = whiteNodes;
                        isWhiteCode = true;
                    }
                    if (remaining == 0) {
                        remaining = this.scanLineWidth;
                        markByteOffset = this.byteOffset;
                        markBitOffset = this.bitOffset;
                        if (isWhiteCode) {
                            markCurrNode = whiteNodes;
                            markIsWhiteCode = true;
                        } else {
                            markCurrNode = blackNodes;
                            markIsWhiteCode = false;
                        }
                        expectEOL = true;
                    }
                    runLen = 0;
                    continue;
                }
                if (isWhiteCode) {
                    currNode = whiteNodes;
                    continue;
                }
                currNode = blackNodes;
                continue;
            }
            if (remaining != this.scanLineWidth) {
                this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, remaining, this.scanLineWidth, 0, len);
                remaining = this.scanLineWidth;
            }
            expectEOL = false;
            isWhiteCode = true;
            currNode = whiteNodes;
        }
        if (this.totalRunLen < this.scanLineWidth * this.rowsPerStrip) {
            this.destByteOffset = this.outputRunLen(pix, this.destByteOffset, this.scanLineWidth * this.rowsPerStrip - this.totalRunLen, this.scanLineWidth, 0, len);
        }
        return this.uncompressedBytes;
    }
}

