/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.compression.ccitt;

import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.ccitt.G31DEncoder;
import guilibshadow.cafe4j.image.compression.ccitt.T42DCode;
import guilibshadow.cafe4j.image.compression.ccitt.T4WhiteCode;
import guilibshadow.cafe4j.util.Updatable;
import java.io.OutputStream;

public class G32DEncoder
extends G31DEncoder
implements ImageEncoder {
    private int k;
    private int a0 = -1;
    private int a1;
    private int a2;
    private int b1;
    private int b2;

    public G32DEncoder(OutputStream os, int scanLineWidth, int buf_length, int k, Updatable<Integer> writer) {
        super(os, scanLineWidth, buf_length, writer);
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k value: " + k);
        }
        this.k = k;
    }

    @Override
    public void encode(byte[] pixels, int start, int len) throws Exception {
        int i;
        int totalScanLines = len / this.scanLineWidth;
        int numOfKLines = totalScanLines / this.k;
        int leftOver = totalScanLines % this.k;
        for (i = 0; i < numOfKLines; ++i) {
            start = this.encodeKLines(pixels, start);
        }
        if (leftOver > 0) {
            this.send_code_to_buffer(24, 13);
            start = this.encode1DLine(pixels, start);
            for (i = 0; i < leftOver - 1; ++i) {
                this.send_code_to_buffer(16, 13);
                start = this.encode2DLine(pixels, start);
            }
        }
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.setExtraFlush(true);
    }

    private int encodeKLines(byte[] pixels, int start) throws Exception {
        this.send_code_to_buffer(24, 13);
        start = this.encode1DLine(pixels, start);
        for (int i = 0; i < this.k - 1; ++i) {
            this.send_code_to_buffer(16, 13);
            start = this.encode2DLine(pixels, start);
        }
        return start;
    }

    protected int encode2DLine(byte[] pixels, int start) throws Exception {
        boolean endOfLine = false;
        int color = 0;
        int currRefPos = this.currPos;
        int preRefPos = currRefPos + this.scanLineWidth % 8;
        if (preRefPos > 7) {
            preRefPos -= 8;
        }
        int prevStart = ((start + 1 << 3) - currRefPos - this.scanLineWidth + 7 >> 3) - 1;
        int bias = 7;
        this.a0 = -1;
        while (!endOfLine) {
            int offset = this.a0 + 1;
            int begin = start + (offset - currRefPos + 7) / 8;
            if (offset >= this.scanLineWidth) {
                this.a1 = this.scanLineWidth;
            } else {
                bias = currRefPos - offset % 8;
                if (bias < 0) {
                    bias += 8;
                }
                color = this.a0 == -1 ? 0 : (bias == 7 ? pixels[begin - 1] & 1 : pixels[begin] >>> bias + 1 & 1);
                this.a1 = this.findChangingElement(pixels, begin, color, bias, offset, true);
                if (this.a1 == -1) {
                    this.a1 = this.scanLineWidth;
                }
            }
            offset = this.a0 + 1;
            begin = prevStart + (offset - preRefPos + 7) / 8;
            if (begin < 0) {
                this.b1 = this.scanLineWidth;
            } else if (offset >= this.scanLineWidth) {
                this.b1 = this.scanLineWidth;
            } else {
                bias = preRefPos - offset % 8;
                if (bias < 0) {
                    bias += 8;
                }
                this.b1 = this.findChangingElement(pixels, begin, color, bias, offset, false);
                if (this.b1 == -1) {
                    this.b1 = this.scanLineWidth;
                }
            }
            color ^= 1;
            offset = this.b1 + 1;
            begin = prevStart + (offset - preRefPos + 7) / 8;
            if (offset >= this.scanLineWidth) {
                this.b2 = this.scanLineWidth;
            } else {
                bias = preRefPos - offset % 8;
                if (bias < 0) {
                    bias += 8;
                }
                this.b2 = this.findChangingElement(pixels, begin, color, bias, offset, true);
                if (this.b2 == -1) {
                    this.b2 = this.scanLineWidth;
                }
            }
            if (this.b2 < this.a1) {
                this.send_code_to_buffer(T42DCode.P.getCode(), T42DCode.P.getCodeLen());
                this.a0 = this.b2;
            } else {
                int a1b1 = this.a1 - this.b1;
                if (Math.abs(a1b1) <= 3) {
                    if (a1b1 == 0) {
                        this.send_code_to_buffer(T42DCode.V0.getCode(), T42DCode.V0.getCodeLen());
                    } else if (a1b1 == 1) {
                        this.send_code_to_buffer(T42DCode.VR1.getCode(), T42DCode.VR1.getCodeLen());
                    } else if (a1b1 == 2) {
                        this.send_code_to_buffer(T42DCode.VR2.getCode(), T42DCode.VR2.getCodeLen());
                    } else if (a1b1 == 3) {
                        this.send_code_to_buffer(T42DCode.VR3.getCode(), T42DCode.VR3.getCodeLen());
                    } else if (a1b1 == -1) {
                        this.send_code_to_buffer(T42DCode.VL1.getCode(), T42DCode.VL1.getCodeLen());
                    } else if (a1b1 == -2) {
                        this.send_code_to_buffer(T42DCode.VL2.getCode(), T42DCode.VL2.getCodeLen());
                    } else if (a1b1 == -3) {
                        this.send_code_to_buffer(T42DCode.VL3.getCode(), T42DCode.VL3.getCodeLen());
                    }
                    this.a0 = this.a1;
                } else {
                    this.send_code_to_buffer(T42DCode.H.getCode(), T42DCode.H.getCodeLen());
                    int len = this.a1 - this.a0;
                    if (this.a0 == -1) {
                        --len;
                    }
                    if (len == 0) {
                        T4WhiteCode code = T4WhiteCode.CODE0;
                        short codeValue = code.getCode();
                        int codeLen = code.getCodeLen();
                        this.send_code_to_buffer(codeValue, codeLen);
                    } else {
                        this.outputRunLengthCode(len, color ^ 1);
                    }
                    offset = this.a1 + 1;
                    begin = start + (offset - currRefPos + 7) / 8;
                    if (offset >= this.scanLineWidth) {
                        this.a2 = this.scanLineWidth;
                    } else {
                        bias = currRefPos - offset % 8;
                        if (bias < 0) {
                            bias += 8;
                        }
                        this.a2 = this.findChangingElement(pixels, begin, color, bias, offset, true);
                        if (this.a2 == -1) {
                            this.a2 = this.scanLineWidth;
                        }
                    }
                    len = this.a2 - this.a1;
                    this.outputRunLengthCode(len, color);
                    this.a0 = this.a2;
                }
            }
            if (this.a0 < this.scanLineWidth) continue;
            endOfLine = true;
        }
        this.currPos = currRefPos - this.scanLineWidth % 8;
        if (this.currPos < 0) {
            this.currPos += 8;
        }
        return start + (this.scanLineWidth - currRefPos + 7) / 8;
    }

    private int findChangingElement(byte[] pixels, int begin, int color, int bias, int offset, boolean sameLine) {
        int upperColor;
        if (sameLine) {
            return this.find(pixels, begin, color, bias, offset, true);
        }
        int n = this.a0 == -1 ? 0 : (upperColor = bias == 7 ? pixels[begin - 1] & 1 : pixels[begin] >>> bias + 1 & 1);
        if (color == upperColor) {
            return this.find(pixels, begin, color, bias, offset, true);
        }
        return this.find(pixels, begin, upperColor, bias, offset, false);
    }

    private int find(byte[] pixels, int begin, int color, int bias, int offset, boolean sameLine) {
        int changingElement = -1;
        while (bias >= 0) {
            if ((pixels[begin] >>> bias & 1) == color) {
                ++offset;
                --bias;
            } else {
                --bias;
                if (sameLine) {
                    changingElement = offset++;
                    break;
                }
                ++offset;
                color ^= 1;
                sameLine = true;
            }
            if (offset >= this.scanLineWidth) break;
            if (bias >= 0) continue;
            bias = 7;
            ++begin;
        }
        return changingElement;
    }
}

